/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import net.minecraft.client.input.InputDevice;
import org.lwjgl.input.Mouse;

public class InputDeviceMouse
extends InputDevice {
    private static final String[] MOUSE_BUTTON_NAMES = new String[]{"LEFT CLICK", "RIGHT CLICK", "MIDDLE CLICK"};

    @Override
    public boolean isPressed(int keyCode) {
        return Mouse.isButtonDown((int)keyCode);
    }

    @Override
    public boolean isPressEvent(int keyCode) {
        return Mouse.getEventButton() == keyCode && Mouse.getEventButtonState();
    }

    @Override
    public boolean isReleaseEvent(int keyCode) {
        return Mouse.getEventButton() == keyCode && !Mouse.getEventButtonState();
    }

    @Override
    public boolean isKeyCodeValid(int keyCode) {
        return keyCode >= 0;
    }

    @Override
    public String getKeyName(int keyCode) {
        if (keyCode < MOUSE_BUTTON_NAMES.length) {
            return MOUSE_BUTTON_NAMES[keyCode];
        }
        return "MOUSE " + (keyCode + 1);
    }
}

