/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockFarmland;
import net.minecraft.core.util.helper.Side;

public class BlockModelFarmland<T extends Block>
extends BlockModelStandard<T> {
    protected IconCoordinate topWet = TextureRegistry.getTexture("minecraft:block/farmland_wet_top");
    protected IconCoordinate topWetFertilized = TextureRegistry.getTexture("minecraft:block/farmland_wet_fertilized_top");
    protected IconCoordinate topDry = TextureRegistry.getTexture("minecraft:block/farmland_dry_top");
    protected IconCoordinate topDryFertilized = TextureRegistry.getTexture("minecraft:block/farmland_dry_fertilized_top");
    protected IconCoordinate mud = TextureRegistry.getTexture("minecraft:block/mud");

    public BlockModelFarmland(Block block) {
        super(block);
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        boolean isWet = BlockFarmland.isWet(data);
        boolean isFertilized = BlockFarmland.isFertilized(data);
        if (side == Side.TOP) {
            if (isWet && isFertilized) {
                return this.topWetFertilized;
            }
            if (isWet) {
                return this.topWet;
            }
            if (isFertilized) {
                return this.topDryFertilized;
            }
            return this.topDry;
        }
        if (isWet) {
            return this.mud;
        }
        return this.atlasIndices[side.getId()];
    }
}

