/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.color.BlockColor;
import net.minecraft.client.render.block.color.BlockColorDispatcher;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockStairs;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.opengl.GL11;

public class BlockModelStairs<T extends BlockStairs>
extends BlockModelStandard<T> {
    public BlockModelStairs(Block block) {
        super(block);
        this.atlasIndices = ((BlockModelStandard)BlockModelDispatcher.getInstance().getDispatch(((BlockStairs)this.block).modelBlock)).atlasIndices;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        float stepYOffset;
        ((BlockStairs)this.block).setBlockBoundsBasedOnState(BlockModelStairs.renderBlocks.blockAccess, x, y, z);
        int meta = BlockModelStairs.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        int hRotation = meta & 3;
        int vRotation = meta & 8;
        float f = stepYOffset = vRotation > 0 ? 0.5f : 0.0f;
        if (hRotation == 0) {
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0f + stepYOffset, 0.0, 0.5, 0.5f + stepYOffset, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            ((BlockStairs)this.block).setBlockBounds(0.5, 0.0, 0.0, 1.0, 1.0, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        } else if (hRotation == 1) {
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.0, 0.5, 1.0, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            ((BlockStairs)this.block).setBlockBounds(0.5, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        } else if (hRotation == 2) {
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0f + stepYOffset, 0.0, 1.0, 0.5f + stepYOffset, 0.5);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.5, 1.0, 1.0, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        } else {
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            ((BlockStairs)this.block).setBlockBounds(0.0, 0.0f + stepYOffset, 0.5, 1.0, 0.5f + stepYOffset, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    @Override
    public void renderBlockOnInventory(Tessellator tessellator, int metadata, float brightness, float alpha, @Nullable Integer lightmapCoordinate) {
        if (BlockModelStairs.renderBlocks.useInventoryTint) {
            int j = ((BlockColor)BlockColorDispatcher.getInstance().getDispatch(this.block)).getFallbackColor(metadata);
            float f1 = (float)(j >> 16 & 0xFF) / 255.0f;
            float f3 = (float)(j >> 8 & 0xFF) / 255.0f;
            float f5 = (float)(j & 0xFF) / 255.0f;
            GL11.glColor4f((float)(f1 * brightness), (float)(f3 * brightness), (float)(f5 * brightness), (float)alpha);
        }
        for (int l = 0; l < 2; ++l) {
            if (l == 0) {
                ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 0.5);
            }
            if (l == 1) {
                ((BlockStairs)this.block).setBlockBounds(0.0, 0.0, 0.5, 1.0, 0.5, 1.0);
            }
            GL11.glTranslatef((float)-0.5f, (float)-0.5f, (float)-0.5f);
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, -1.0f, 0.0f);
            this.renderBottomFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 1.0f, 0.0f);
            this.renderTopFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.TOP, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, -1.0f);
            this.renderNorthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.NORTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(0.0f, 0.0f, 1.0f);
            this.renderSouthFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.SOUTH, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(-1.0f, 0.0f, 0.0f);
            this.renderWestFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.WEST, metadata));
            tessellator.draw();
            tessellator.startDrawingQuads();
            tessellator.setNormal(1.0f, 0.0f, 0.0f);
            this.renderEastFace(tessellator, this.block, 0.0, 0.0, 0.0, this.getBlockTextureFromSideAndMetadata(Side.EAST, metadata));
            tessellator.draw();
            GL11.glTranslatef((float)0.5f, (float)0.5f, (float)0.5f);
        }
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        return ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(((BlockStairs)this.block).modelBlock)).getBlockTextureFromSideAndMetadata(side, data);
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        return ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(((BlockStairs)this.block).modelBlock)).getBlockTexture(blockAccess, x, y, z, side);
    }
}

