/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.Vec3d;

public class HitResult {
    public final HitType hitType;
    public final int x;
    public final int y;
    public final int z;
    public final Side side;
    public final Vec3d location;
    public final Entity entity;

    public HitResult(int x, int y, int z, Side side, Vec3d vec3d) {
        this.hitType = HitType.TILE;
        this.x = x;
        this.y = y;
        this.z = z;
        this.side = side;
        this.location = Vec3d.createVector(vec3d.xCoord, vec3d.yCoord, vec3d.zCoord);
        this.entity = null;
    }

    public HitResult(Entity entity) {
        this.x = 0;
        this.y = 0;
        this.z = 0;
        this.side = null;
        this.hitType = HitType.ENTITY;
        this.entity = entity;
        this.location = Vec3d.createVector(entity.x, entity.y, entity.z);
    }

    public static enum HitType {
        TILE,
        ENTITY;

    }
}

