/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockTileEntityRotatable;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.entity.TileEntityDispenser;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.entity.projectile.EntityArrow;
import net.minecraft.core.entity.projectile.EntityArrowGolden;
import net.minecraft.core.entity.projectile.EntityCannonball;
import net.minecraft.core.item.IDispensable;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class BlockDispenser
extends BlockTileEntityRotatable {
    private Random random = new Random();

    public BlockDispenser(String key, int id) {
        super(key, id, Material.stone);
    }

    @Override
    public int tickRate() {
        return 4;
    }

    @Override
    public void onBlockAdded(World world, int x, int y, int z) {
        super.onBlockAdded(world, x, y, z);
        this.setDispenserDefaultDirection(world, x, y, z);
    }

    private void setDispenserDefaultDirection(World world, int i, int j, int k) {
        if (world.isClientSide) {
            return;
        }
        int l = world.getBlockId(i, j, k - 1);
        int i1 = world.getBlockId(i, j, k + 1);
        int j1 = world.getBlockId(i - 1, j, k);
        int k1 = world.getBlockId(i + 1, j, k);
        int byte0 = 3;
        if (Block.solid[l] && !Block.solid[i1]) {
            byte0 = 3;
        }
        if (Block.solid[i1] && !Block.solid[l]) {
            byte0 = 2;
        }
        if (Block.solid[j1] && !Block.solid[k1]) {
            byte0 = 5;
        }
        if (Block.solid[k1] && !Block.solid[j1]) {
            byte0 = 4;
        }
        world.setBlockMetadataWithNotify(i, j, k, byte0);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xPlaced, double yPlaced) {
        if (world.isClientSide) {
            return true;
        }
        TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(x, y, z);
        player.displayGUIDispenser(tileentitydispenser);
        return true;
    }

    private void dispenseItem(World world, int x, int y, int z, Random random) {
        int data = world.getBlockMetadata(x, y, z);
        int xOffset = 0;
        int zOffset = 0;
        if (data == 3) {
            zOffset = 1;
        } else if (data == 2) {
            zOffset = -1;
        } else {
            xOffset = data == 5 ? 1 : -1;
        }
        TileEntityDispenser tileEntity = (TileEntityDispenser)world.getBlockTileEntity(x, y, z);
        ItemStack itemStack = tileEntity.getRandomStackFromInventory();
        double px = (double)x + (double)xOffset * 0.6 + 0.5;
        double py = (double)y + 0.5;
        double pz = (double)z + (double)zOffset * 0.6 + 0.5;
        if (itemStack == null) {
            world.playSoundEffect(1001, x, y, z, 0);
        } else {
            if (itemStack.getItem() instanceof IDispensable) {
                IDispensable dispensable = (IDispensable)((Object)itemStack.getItem());
                dispensable.onDispensed(itemStack, world, px, py, pz, xOffset, zOffset, random);
                world.playSoundEffect(1002, x, y, z, 0);
            } else if (itemStack.itemID == Item.ammoArrow.id || itemStack.itemID == Item.ammoArrowGold.id) {
                EntityArrow arrow = itemStack.itemID == Item.ammoArrow.id ? new EntityArrow(world, px, py, pz, 0) : new EntityArrowGolden(world, px, py, pz);
                arrow.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
                arrow.setDoesArrowBelongToPlayer(true);
                world.entityJoinedWorld(arrow);
                world.playSoundEffect(1002, x, y, z, 0);
            } else if (itemStack.itemID == Item.ammoChargeExplosive.id) {
                EntityCannonball cannonball = new EntityCannonball(world, px, py, pz);
                cannonball.setHeading(xOffset, 0.1, zOffset, 1.1f, 6.0f);
                world.entityJoinedWorld(cannonball);
                world.playSoundEffect(1002, x, y, z, 0);
            } else {
                EntityItem item = new EntityItem(world, px, py - 0.3, pz, itemStack);
                double randOffset = random.nextDouble() * 0.1 + 0.2;
                item.xd = (double)xOffset * randOffset;
                item.yd = 0.2;
                item.zd = (double)zOffset * randOffset;
                item.xd += random.nextGaussian() * 0.0075 * 6.0;
                item.yd += random.nextGaussian() * 0.0075 * 6.0;
                item.zd += random.nextGaussian() * 0.0075 * 6.0;
                world.entityJoinedWorld(item);
                world.playSoundEffect(1000, x, y, z, 0);
            }
            world.playSoundEffect(2000, x, y, z, xOffset + 1 + (zOffset + 1) * 3);
        }
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (blockId > 0 && Block.blocksList[blockId].canProvidePower()) {
            boolean flag;
            boolean bl = flag = world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z);
            if (flag) {
                world.scheduleBlockUpdate(x, y, z, this.id, this.tickRate());
            }
        }
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isBlockIndirectlyGettingPowered(x, y, z) || world.isBlockIndirectlyGettingPowered(x, y + 1, z)) {
            this.dispenseItem(world, x, y, z, rand);
        }
    }

    @Override
    protected TileEntity getNewBlockEntity() {
        return new TileEntityDispenser();
    }

    @Override
    public void onBlockRemoved(World world, int x, int y, int z, int data) {
        if (world.getBlockTileEntity(x, y, z) != null) {
            TileEntityDispenser tileentitydispenser = (TileEntityDispenser)world.getBlockTileEntity(x, y, z);
            for (int l = 0; l < tileentitydispenser.getSizeInventory(); ++l) {
                ItemStack itemstack = tileentitydispenser.getStackInSlot(l);
                if (itemstack == null) continue;
                float f = this.random.nextFloat() * 0.8f + 0.1f;
                float f1 = this.random.nextFloat() * 0.8f + 0.1f;
                float f2 = this.random.nextFloat() * 0.8f + 0.1f;
                while (itemstack.stackSize > 0) {
                    int i1 = this.random.nextInt(21) + 10;
                    if (i1 > itemstack.stackSize) {
                        i1 = itemstack.stackSize;
                    }
                    itemstack.stackSize -= i1;
                    EntityItem entityitem = new EntityItem(world, (float)x + f, (float)y + f1, (float)z + f2, new ItemStack(itemstack.itemID, i1, itemstack.getMetadata()));
                    float f3 = 0.05f;
                    entityitem.xd = (float)this.random.nextGaussian() * f3;
                    entityitem.yd = (float)this.random.nextGaussian() * f3 + 0.2f;
                    entityitem.zd = (float)this.random.nextGaussian() * f3;
                    world.entityJoinedWorld(entityitem);
                }
            }
        }
        super.onBlockRemoved(world, x, y, z, data);
    }
}

