/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockGlowStone
extends Block {
    public BlockGlowStone(String key, int id, Material material) {
        super(key, id, material);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: {
                return new ItemStack[]{new ItemStack(this)};
            }
        }
        return new ItemStack[]{new ItemStack(Item.dustGlowstone, 2 + world.rand.nextInt(2))};
    }

    @Override
    public float getAmbientOcclusionStrength(WorldSource blockAccess, int x, int y, int z) {
        return 0.0f;
    }
}

