/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockLadder
extends Block {
    public BlockLadder(String key, int id) {
        super(key, id, Material.wood);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public boolean isClimbable(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        this.setBlockBounds(world.getBlockMetadata(x, y, z));
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBounds(world.getBlockMetadata(x, y, z));
        return super.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        this.setBlockBounds(world.getBlockMetadata(x, y, z));
        return super.getSelectedBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canExistAt(world, x, y, z, world.getBlockMetadata(x, y, z))) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, blockId, null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public final boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return true;
    }

    @Override
    public final boolean canPlaceBlockOnSide(World world, int x, int y, int z, int side) {
        return true;
    }

    public Side getSideForPlacement(World world, int x, int y, int z, Side clickedSide) {
        if (!world.canPlaceInsideBlock(x, y, z)) {
            x += clickedSide.getOffsetX();
            y += clickedSide.getOffsetY();
            z += clickedSide.getOffsetZ();
        }
        if (clickedSide != null && this.canExistAt(world, x, y, z, this.getMetaForSide(clickedSide))) {
            return clickedSide;
        }
        if (this.canExistAt(world, x, y, z, this.getMetaForSide(Side.NORTH))) {
            return Side.NORTH;
        }
        if (this.canExistAt(world, x, y, z, this.getMetaForSide(Side.SOUTH))) {
            return Side.SOUTH;
        }
        if (this.canExistAt(world, x, y, z, this.getMetaForSide(Side.WEST))) {
            return Side.WEST;
        }
        if (this.canExistAt(world, x, y, z, this.getMetaForSide(Side.EAST))) {
            return Side.EAST;
        }
        return null;
    }

    public boolean canExistAt(World world, int x, int y, int z, int meta) {
        Side side = this.getSideFromMeta(meta).getOpposite();
        return world.isBlockNormalCube(x += side.getOffsetX(), y += side.getOffsetY(), z += side.getOffsetZ());
    }

    public void setBlockBounds(int meta) {
        Side side = this.getSideFromMeta(meta);
        float width = 0.1875f;
        if (side == Side.SOUTH) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, width);
        } else if (side == Side.WEST) {
            this.setBlockBounds(1.0f - width, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else if (side == Side.EAST) {
            this.setBlockBounds(0.0, 0.0, 0.0, width, 1.0, 1.0);
        } else {
            this.setBlockBounds(0.0, 0.0, 1.0f - width, 1.0, 1.0, 1.0);
        }
    }

    public Side getSideFromMeta(int meta) {
        if (meta == 2) {
            return Side.NORTH;
        }
        if (meta == 3) {
            return Side.SOUTH;
        }
        if (meta == 4) {
            return Side.WEST;
        }
        if (meta == 5) {
            return Side.EAST;
        }
        return Side.NONE;
    }

    public int getMetaForSide(Side side) {
        if (side == Side.NORTH) {
            return 2;
        }
        if (side == Side.SOUTH) {
            return 3;
        }
        if (side == Side.WEST) {
            return 4;
        }
        if (side == Side.EAST) {
            return 5;
        }
        return 0;
    }
}

