/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.animal.EntityFireflyCluster;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;
import org.jetbrains.annotations.NotNull;

public class BlockLanternFirefly
extends Block {
    public Item item;
    private final Supplier<Item> itemSupplier;
    private final EntityFireflyCluster.FireflyColor color;

    public BlockLanternFirefly(String key, int id, EntityFireflyCluster.FireflyColor colour, @NotNull Supplier<Item> itemSupplier) {
        super(key, id, Material.glass);
        this.color = colour;
        this.itemSupplier = itemSupplier;
        this.setBlockBounds(0.3125, 0.0, 0.3125, 0.6875, 0.5, 0.6875);
    }

    @Override
    public void initializeBlock() {
        this.item = this.itemSupplier.get();
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int metadata = world.getBlockMetadata(x, y, z);
        float offset = 0.0f;
        if (metadata == 1) {
            offset = 0.3875f;
        }
        return AABB.getBoundingBoxFromPool((float)x + 0.3125f, (float)y + offset, (float)z + 0.3125f, (float)(x + 1) - 0.3125f, (float)y + 0.5f + offset, (float)(z + 1) - 0.3125f);
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        AABB aabb = this.getCollisionBoundingBoxFromPool(world, x, y, z);
        this.minX = aabb.minX - (double)x;
        this.minY = aabb.minY - (double)y;
        this.minZ = aabb.minZ - (double)z;
        this.maxX = aabb.maxX - (double)x;
        this.maxY = aabb.maxY - (double)y;
        this.maxZ = aabb.maxZ - (double)z;
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlock() {
        return false;
    }

    @Override
    public void randomDisplayTick(World world, int x, int y, int z, Random rand) {
        if (rand.nextInt(3) == 0) {
            world.spawnParticle(this.color.getParticleName(), (double)x + (double)rand.nextFloat(), (double)y + (double)rand.nextFloat(), (double)z + (double)rand.nextFloat(), 0.0, 0.0, 0.0, 0);
        }
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, EntityPlayer player, Side side, double xPlaced, double yPlaced) {
        world.setBlockRaw(x, y, z, 0);
        world.playSoundAtEntity(player, player, "random.pop", 0.2f, 0.5f);
        if (!world.isClientSide) {
            world.dropItem(x, y, z, new ItemStack(this.item, 1, 0));
        }
        return true;
    }

    @Override
    public void onBlockPlaced(World world, int x, int y, int z, Side side, EntityLiving entity, double sideHeight) {
        if ((side == Side.BOTTOM || side != Side.TOP && sideHeight >= 0.5) && (world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF))) {
            world.setBlockMetadataWithNotify(x, y, z, 1);
            return;
        }
        if ((side == Side.TOP || side != Side.BOTTOM && sideHeight < 0.5) && world.canPlaceOnSurfaceOfBlock(x, y - 1, z)) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
            return;
        }
        if (world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF)) {
            world.setBlockMetadataWithNotify(x, y, z, 1);
        } else {
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        if (world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF)) {
            return true;
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        if (!this.canBlockStay(world, x, y, z)) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
        }
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        switch (dropCause) {
            case PICK_BLOCK: 
            case SILK_TOUCH: 
            case WORLD: {
                return new ItemStack[]{new ItemStack(this.item)};
            }
        }
        return null;
    }

    @Override
    public boolean canBlockStay(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        if (meta == 1) {
            return world.isBlockNormalCube(x, y + 1, z) || Block.hasTag(world.getBlockId(x, y + 1, z), BlockTags.CAN_HANG_OFF);
        }
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z);
    }

    @Override
    public void onBlockDestroyedByPlayer(World world, int x, int y, int z, Side side, int meta, EntityPlayer player, Item item) {
        if (item != null && item.isSilkTouch()) {
            return;
        }
        if (!world.isClientSide) {
            EntityFireflyCluster entity = new EntityFireflyCluster(world);
            entity.setColor(this.color);
            entity.setFireflyCount(1);
            entity.setClusterSize(0);
            entity.setSizeBasedOnClusterSize(entity.getClusterSize());
            entity.setPos((float)x + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f, (float)y + world.rand.nextFloat() * 0.5f, (float)z + 0.5f + (world.rand.nextFloat() - 0.5f) * 0.5f);
            world.entityJoinedWorld(entity);
        }
    }
}

