/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockCobweb;
import net.minecraft.core.block.entity.TileEntity;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityItem;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.DamageType;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class BlockSpikes
extends BlockCobweb {
    public BlockSpikes(String key, int id, Material mat) {
        super(key, id, mat);
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, TileEntity tileEntity) {
        return new ItemStack[]{new ItemStack(Block.spikes)};
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.canPlaceOnSurfaceOfBlock(x, y - 1, z) || world.getBlockId(x, y - 1, z) == Block.mobspawner.id;
    }

    @Override
    public void onNeighborBlockChange(World world, int x, int y, int z, int blockId) {
        boolean destroy;
        if (world.isClientSide) {
            return;
        }
        boolean bl = destroy = !world.canPlaceOnSurfaceOfBlock(x, y - 1, z) && world.getBlockId(x, y - 1, z) != Block.mesh.id && world.getBlockId(x, y - 1, z) != Block.mobspawner.id;
        if (destroy) {
            this.dropBlockWithCause(world, EnumDropCause.WORLD, x, y, z, world.getBlockMetadata(x, y, z), null);
            world.setBlockWithNotify(x, y, z, 0);
            return;
        }
        int meta = world.getBlockMetadata(x, y, z);
        boolean wasPowered = (meta & 1) > 0;
        boolean isPowered = world.isBlockIndirectlyGettingPowered(x, y, z);
        if (isPowered != wasPowered) {
            if (isPowered) {
                world.playSoundEffect(null, 1007, x, y, z, 0);
                world.setBlockMetadataWithNotify(x, y, z, 1);
            } else {
                world.playSoundEffect(null, 1006, x, y, z, 0);
                world.setBlockMetadataWithNotify(x, y, z, 0);
            }
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        float f = 0.0625f;
        return AABB.getBoundingBoxFromPool((float)x + f, y, (float)z + f, (float)(x + 1) - f, (float)y + 0.1875f, (float)(z + 1) - f);
    }

    @Override
    public void onEntityCollidedWithBlock(World world, int x, int y, int z, Entity entity) {
        int metaData = world.getBlockMetadata(x, y, z);
        if (BlockSpikes.isSpikesUp(metaData) && entity instanceof EntityLiving) {
            if (entity.fallDistance > 1.5f) {
                entity.hurt(null, MathHelper.floor_double(entity.fallDistance) * 2 + 1, DamageType.COMBAT);
                entity.stuck = true;
            } else if (entity.isWalking) {
                entity.hurt(null, 1, DamageType.COMBAT);
            }
        }
    }

    @Override
    public boolean collidesWithEntity(Entity entity, World world, int x, int y, int z) {
        return !(entity instanceof EntityItem);
    }

    public static boolean isSpikesUp(int i) {
        return (i & 1) != 1;
    }
}

