/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.data.registry.recipe.entry;

import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryCraftingDynamic;
import net.minecraft.core.item.Item;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.InventoryCrafting;

public class RecipeEntryCraftingWithTool
extends RecipeEntryCraftingDynamic {
    public ItemStack inItemStack;
    public Item toolToUse;
    public ItemStack output;

    public RecipeEntryCraftingWithTool(ItemStack inItemStack, Item toolToUse, ItemStack output) {
        this.inItemStack = inItemStack;
        this.toolToUse = toolToUse;
        this.output = output;
    }

    public RecipeEntryCraftingWithTool() {
    }

    @Override
    public boolean matches(InventoryCrafting inventorycrafting) {
        boolean toolMatch = false;
        boolean itemMatch = false;
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                if (stack.itemID == this.toolToUse.id) {
                    toolMatch = true;
                    continue;
                }
                if (stack.itemID == this.inItemStack.itemID) {
                    itemMatch = true;
                    continue;
                }
                return false;
            }
        }
        return toolMatch && itemMatch;
    }

    @Override
    public boolean matchesQuery(SearchQuery query) {
        return false;
    }

    @Override
    public ItemStack getCraftingResult(InventoryCrafting inventorycrafting) {
        return new ItemStack(this.output.itemID, this.output.stackSize, this.output.getMetadata());
    }

    @Override
    public ItemStack[] onCraftResult(InventoryCrafting inventorycrafting) {
        ItemStack[] returnStack = new ItemStack[9];
        for (int x = 0; x < 3; ++x) {
            for (int y = 0; y < 3; ++y) {
                ItemStack stack = inventorycrafting.getItemStackAt(x, y);
                if (stack == null) continue;
                ItemStack stack2 = stack.getItem() == this.toolToUse ? (stack.getMetadata() + 1 > stack.getMaxDamage() ? null : new ItemStack(stack.getItem(), stack.stackSize, stack.getMetadata() + 1)) : (stack.stackSize - 1 == 0 ? null : new ItemStack(stack.getItem(), stack.stackSize - 1));
                inventorycrafting.setSlotContentsAt(x, y, stack2);
            }
        }
        return returnStack;
    }

    @Override
    public int getRecipeSize() {
        return 2;
    }
}

