/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity;

import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.item.ItemFood;

public class ConsumedFood {
    private final EntityLiving entity;
    private final ItemFood food;
    private int healRemaining;
    private int tickCounter = 0;

    public ConsumedFood(EntityLiving entity, ItemFood food) {
        this.entity = entity;
        this.food = food;
        this.healRemaining = food.getHealAmount();
    }

    public void addFood() {
        this.healRemaining += this.food.getHealAmount();
    }

    public int getHealRemaining() {
        return this.healRemaining;
    }

    public boolean isFinished() {
        return this.healRemaining <= 0;
    }

    public void tick() {
        if (this.isFinished()) {
            return;
        }
        ++this.tickCounter;
        if (this.tickCounter >= this.food.getTicksPerHeal()) {
            this.tickCounter = 0;
            --this.healRemaining;
            this.entity.heal(1);
        }
    }
}

