/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.entity.animal;

import com.mojang.nbt.CompoundTag;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.AchievementList;
import net.minecraft.core.entity.EntityLightningBolt;
import net.minecraft.core.entity.animal.EntityAnimal;
import net.minecraft.core.entity.monster.EntityPigZombie;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.Item;
import net.minecraft.core.util.collection.NamespaceID;
import net.minecraft.core.world.World;

public class EntityPig
extends EntityAnimal {
    public List<WeightedRandomLootObject> burningMobDrops = new ArrayList<WeightedRandomLootObject>();

    public EntityPig(World world) {
        super(world);
        this.textureIdentifier = new NamespaceID("minecraft", "pig");
        this.setSize(0.9f, 0.9f);
        this.mobDrops.add(new WeightedRandomLootObject(Item.foodPorkchopRaw.getDefaultStack(), 1, 2));
        this.burningMobDrops.add(new WeightedRandomLootObject(Item.foodPorkchopCooked.getDefaultStack(), 1, 2));
    }

    @Override
    protected void init() {
        this.entityData.define(16, (byte)0);
    }

    @Override
    public void addAdditionalSaveData(CompoundTag tag) {
        super.addAdditionalSaveData(tag);
        tag.putBoolean("Saddle", this.getSaddled());
    }

    @Override
    public void readAdditionalSaveData(CompoundTag tag) {
        super.readAdditionalSaveData(tag);
        this.setSaddled(tag.getBoolean("Saddle"));
    }

    @Override
    public String getLivingSound() {
        return "mob.pig";
    }

    @Override
    protected String getHurtSound() {
        return "mob.pig";
    }

    @Override
    protected String getDeathSound() {
        return "mob.pigdeath";
    }

    @Override
    public boolean interact(EntityPlayer entityplayer) {
        if (super.interact(entityplayer)) {
            return true;
        }
        if (this.getSaddled() && !this.world.isClientSide && (this.passenger == null || this.passenger == entityplayer)) {
            entityplayer.startRiding(this);
            return true;
        }
        return false;
    }

    @Override
    protected void dropFewItems() {
        if (this.getSaddled()) {
            this.spawnAtLocation(Item.saddle.id, 1);
        }
        super.dropFewItems();
    }

    @Override
    protected List<WeightedRandomLootObject> getMobDrops() {
        if (this.remainingFireTicks > 0) {
            return this.burningMobDrops;
        }
        return this.mobDrops;
    }

    public boolean getSaddled() {
        return (this.entityData.getByte(16) & 1) != 0;
    }

    public void setSaddled(boolean flag) {
        if (flag) {
            this.entityData.set(16, (byte)1);
        } else {
            this.entityData.set(16, (byte)0);
        }
    }

    @Override
    public void thunderHit(EntityLightningBolt bolt) {
        if (this.world.isClientSide) {
            return;
        }
        EntityPigZombie entitypigzombie = new EntityPigZombie(this.world);
        entitypigzombie.moveTo(this.x, this.y, this.z, this.yRot, this.xRot);
        this.world.entityJoinedWorld(entitypigzombie);
        this.remove();
    }

    @Override
    protected void causeFallDamage(float f) {
        super.causeFallDamage(f);
        if (f > 5.0f && this.passenger instanceof EntityPlayer) {
            ((EntityPlayer)this.passenger).triggerAchievement(AchievementList.FLY_PIG);
        }
    }
}

