/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.client.entity.fx.ParticleDispatcher;
import net.minecraft.core.net.command.ClientCommandHandler;
import net.minecraft.core.net.command.Command;
import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommandHandler;
import net.minecraft.core.net.packet.Packet63SpawnParticleEffect;

public class SpawnParticleCommand
extends Command {
    public SpawnParticleCommand() {
        super("spawnparticle", "particle");
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        String particleKey = null;
        Double x = null;
        Double y = null;
        Double z = null;
        int dimension = 0;
        if (sender.getPlayer() != null) {
            x = sender.getPlayer().x;
            y = sender.getPlayer().y;
            z = sender.getPlayer().z;
            dimension = sender.getPlayer().dimension;
        }
        double motionX = 0.0;
        double motionY = 0.0;
        double motionZ = 0.0;
        int data = 0;
        Double maxDistance = null;
        if (args.length >= 1) {
            particleKey = args[0];
            if (particleKey.equalsIgnoreCase("list")) {
                sender.sendMessage("List of particles:");
                for (String s : ParticleDispatcher.getInstance().getParticleIds()) {
                    sender.sendMessage(" - " + s);
                }
                return true;
            }
            if (args.length >= 4) {
                x = Double.parseDouble(args[1]);
                y = Double.parseDouble(args[2]);
                z = Double.parseDouble(args[3]);
                if (args.length >= 7) {
                    motionX = Double.parseDouble(args[4]);
                    motionY = Double.parseDouble(args[5]);
                    motionZ = Double.parseDouble(args[6]);
                    if (args.length >= 8) {
                        data = Integer.parseInt(args[7]);
                        if (args.length == 9) {
                            maxDistance = Double.parseDouble(args[8]);
                        }
                    }
                }
            }
        }
        if (particleKey != null && x != null) {
            if (handler instanceof ServerCommandHandler) {
                ((ServerCommandHandler)handler).minecraftServer.playerList.sendPacketToPlayersAroundPoint(x, y, z, maxDistance == null ? 16.0 : maxDistance, dimension, new Packet63SpawnParticleEffect(particleKey, x, y, z, motionX, motionY, motionZ, data));
            } else if (handler instanceof ClientCommandHandler) {
                if (maxDistance == null) {
                    ((ClientCommandHandler)handler).minecraft.renderGlobal.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data);
                } else {
                    ((ClientCommandHandler)handler).minecraft.renderGlobal.addParticle(particleKey, x, y, z, motionX, motionY, motionZ, data, maxDistance);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/spawnparticle list");
        if (sender.getPlayer() != null) {
            sender.sendMessage("/spawnparticle <ParticleKey>");
        }
        sender.sendMessage("/spawnparticle <ParticleKey> <x> <y> <z>");
        sender.sendMessage("/spawnparticle <ParticleKey> <x> <y> <z> <MotionX> <MotionY> <MotionZ>");
        sender.sendMessage("/spawnparticle <ParticleKey> <x> <y> <z> <MotionX> <MotionY> <MotionZ> <data>");
        sender.sendMessage("/spawnparticle <ParticleKey> <x> <y> <z> <MotionX> <MotionY> <MotionZ> <data> <MaxDistance>");
    }
}

