/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import com.mojang.nbt.CompoundTag;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;

public class Packet104WindowItems
extends Packet {
    public int windowId;
    public ItemStack[] stackList;

    public Packet104WindowItems() {
    }

    public Packet104WindowItems(int i, List<ItemStack> list) {
        this.windowId = i;
        this.stackList = new ItemStack[list.size()];
        for (int j = 0; j < this.stackList.length; ++j) {
            ItemStack itemstack = list.get(j);
            this.stackList[j] = itemstack != null ? itemstack.copy() : null;
        }
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.windowId = dis.readByte();
        int listSize = dis.readShort();
        this.stackList = new ItemStack[listSize];
        for (int i = 0; i < listSize; ++i) {
            ItemStack s;
            short itemId = dis.readShort();
            if (itemId < 0) continue;
            byte size = dis.readByte();
            short meta = dis.readShort();
            CompoundTag tag = Packet104WindowItems.readCompressedCompoundTag(dis);
            this.stackList[i] = s = new ItemStack(itemId, (int)size, (int)meta, tag);
        }
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeByte(this.windowId);
        dos.writeShort(this.stackList.length);
        for (int i = 0; i < this.stackList.length; ++i) {
            if (this.stackList[i] == null) {
                dos.writeShort(-1);
                continue;
            }
            dos.writeShort((short)this.stackList[i].itemID);
            dos.writeByte((byte)this.stackList[i].stackSize);
            dos.writeShort((short)this.stackList[i].getMetadata());
            Packet104WindowItems.writeCompressedCompoundTag(this.stackList[i].getData(), dos);
        }
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleWindowItems(this);
    }

    @Override
    public int getPacketSize() {
        return 3 + this.stackList.length * 5;
    }
}

