/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.Side;

public class Packet14BlockDig
extends Packet {
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public Side side;
    public double xHit;
    public double yHit;
    public int status;

    public Packet14BlockDig() {
    }

    public Packet14BlockDig(int i, int j, int k, int l, Side side, double xHit, double yHit) {
        this.status = i;
        this.xPosition = j;
        this.yPosition = k;
        this.zPosition = l;
        this.side = side;
        this.xHit = xHit;
        this.yHit = yHit;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.status = dis.read();
        this.xPosition = dis.readInt();
        this.yPosition = dis.read();
        this.zPosition = dis.readInt();
        this.side = Side.getSideById(dis.read());
        this.xHit = dis.readDouble();
        this.yHit = dis.readDouble();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.write(this.status);
        dos.writeInt(this.xPosition);
        dos.write(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.write(this.side.getId());
        dos.writeDouble(this.xHit);
        dos.writeDouble(this.yHit);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleBlockDig(this);
    }

    @Override
    public int getPacketSize() {
        return 19;
    }
}

