/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;

public class Packet23VehicleSpawn
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public float pitch;
    public float yaw;
    public boolean hasVelocity = false;
    public short xVelocity = 0;
    public short yVelocity = 0;
    public short zVelocity = 0;
    public short type = (short)-1;
    public int ownerId = -1;
    public int metaData = -1;

    public Packet23VehicleSpawn() {
    }

    public Packet23VehicleSpawn(Entity entity) {
        this(entity, -1, -1, null, null, null);
    }

    public Packet23VehicleSpawn(Entity entity, int metaData) {
        this(entity, metaData, -1, null, null, null);
    }

    public Packet23VehicleSpawn(Entity entity, int metaData, int ownerId) {
        this(entity, metaData, ownerId, null, null, null);
    }

    public Packet23VehicleSpawn(Entity entity, int metaData, int ownerId, Double xVelocity, Double yVelocity, Double zVelocity) {
        this.entityId = entity.id;
        this.xPosition = MathHelper.floor_double(entity.x * 32.0);
        this.yPosition = MathHelper.floor_double(entity.y * 32.0);
        this.zPosition = MathHelper.floor_double(entity.z * 32.0);
        this.pitch = entity.xRot;
        this.yaw = entity.yRot;
        this.metaData = metaData;
        this.ownerId = ownerId;
        if (xVelocity != null || yVelocity != null || zVelocity != null) {
            this.xVelocity = (short)((xVelocity == null ? 0.0 : xVelocity) * 8000.0);
            this.yVelocity = (short)((yVelocity == null ? 0.0 : yVelocity) * 8000.0);
            this.zVelocity = (short)((zVelocity == null ? 0.0 : zVelocity) * 8000.0);
            this.hasVelocity = true;
        } else {
            this.hasVelocity = false;
        }
    }

    public Packet23VehicleSpawn setType(int type) {
        this.type = (short)type;
        return this;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.type = dis.readShort();
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.pitch = dis.readFloat();
        this.yaw = dis.readFloat();
        byte optionals = dis.readByte();
        if (this.hasVelocity(optionals)) {
            this.xVelocity = dis.readShort();
            this.yVelocity = dis.readShort();
            this.zVelocity = dis.readShort();
            this.hasVelocity = true;
        }
        if (this.hasOwner(optionals)) {
            this.ownerId = dis.readInt();
        }
        if (this.hasMeta(optionals)) {
            this.metaData = dis.readInt();
        }
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeShort(this.type);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.writeFloat(this.pitch);
        dos.writeFloat(this.yaw);
        byte optionals = this.makeOptionalsByte(this.hasVelocity, this.ownerId >= 0, this.metaData >= 0);
        dos.writeByte(optionals);
        if (this.hasVelocity(optionals)) {
            dos.writeShort(this.xVelocity);
            dos.writeShort(this.yVelocity);
            dos.writeShort(this.zVelocity);
        }
        if (this.hasOwner(optionals)) {
            dos.writeInt(this.ownerId);
        }
        if (this.hasMeta(optionals)) {
            dos.writeInt(this.metaData);
        }
    }

    public boolean hasOwner(byte val) {
        return (val & 1) != 0;
    }

    public boolean hasMeta(byte val) {
        return (val & 2) != 0;
    }

    public boolean hasVelocity(byte val) {
        return (val & 4) != 0;
    }

    public byte makeOptionalsByte(boolean hasVelocity, boolean hasOwner, boolean hasMeta) {
        byte val = 0;
        if (hasOwner) {
            val = (byte)(val | 1);
        }
        if (hasMeta) {
            val = (byte)(val | 2);
        }
        if (hasVelocity) {
            val = (byte)(val | 4);
        }
        return val;
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleVehicleSpawn(this);
    }

    @Override
    public int getPacketSize() {
        return 21 + this.ownerId <= 0 ? 0 : 6;
    }
}

