/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.util.helper.MathHelper;

public class Packet34EntityTeleport
extends Packet {
    public int entityId;
    public int xPosition;
    public int yPosition;
    public int zPosition;
    public byte yaw;
    public byte pitch;

    public Packet34EntityTeleport() {
    }

    public Packet34EntityTeleport(Entity entity) {
        this.entityId = entity.id;
        this.xPosition = MathHelper.floor_double(entity.x * 32.0);
        this.yPosition = MathHelper.floor_double(entity.y * 32.0);
        this.zPosition = MathHelper.floor_double(entity.z * 32.0);
        this.yaw = (byte)(entity.yRot * 256.0f / 360.0f);
        this.pitch = (byte)(entity.xRot * 256.0f / 360.0f);
    }

    public Packet34EntityTeleport(int i, int j, int k, int l, byte byte0, byte byte1) {
        this.entityId = i;
        this.xPosition = j;
        this.yPosition = k;
        this.zPosition = l;
        this.yaw = byte0;
        this.pitch = byte1;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        this.entityId = dis.readInt();
        this.xPosition = dis.readInt();
        this.yPosition = dis.readInt();
        this.zPosition = dis.readInt();
        this.yaw = (byte)dis.read();
        this.pitch = (byte)dis.read();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        dos.writeInt(this.entityId);
        dos.writeInt(this.xPosition);
        dos.writeInt(this.yPosition);
        dos.writeInt(this.zPosition);
        dos.write(this.yaw);
        dos.write(this.pitch);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleEntityTeleport(this);
    }

    @Override
    public int getPacketSize() {
        return 34;
    }
}

