/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.packet;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import net.minecraft.core.net.handler.NetHandler;
import net.minecraft.core.net.packet.Packet30Entity;

public class Packet35EntityNickname
extends Packet30Entity {
    public Packet35EntityNickname() {
    }

    public Packet35EntityNickname(int entityId, String nickname, byte chatColor) {
        this.entityId = entityId;
        this.nickname = nickname;
        this.chatColor = chatColor;
    }

    @Override
    public int getPacketSize() {
        return 4 + this.nickname.length() + 1;
    }

    @Override
    public void readPacketData(DataInputStream dis) throws IOException {
        super.readPacketData(dis);
        this.nickname = Packet35EntityNickname.readString(dis, 32);
        this.chatColor = dis.readByte();
    }

    @Override
    public void writePacketData(DataOutputStream dos) throws IOException {
        super.writePacketData(dos);
        Packet35EntityNickname.writeString(this.nickname, dos);
        dos.writeByte(this.chatColor);
    }

    @Override
    public void processPacket(NetHandler netHandler) {
        netHandler.handleEntityNickname(this);
    }
}

