/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.player.inventory;

import java.util.List;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.player.inventory.Container;
import net.minecraft.core.player.inventory.IInventory;
import net.minecraft.core.player.inventory.slot.Slot;

public class ContainerChest
extends Container {
    private IInventory field_20125_a;
    private int numberOfRows;

    public ContainerChest(IInventory iinventory, IInventory iinventory1) {
        this.field_20125_a = iinventory1;
        this.numberOfRows = iinventory1.getSizeInventory() / 9;
        int i = (this.numberOfRows - 4) * 18;
        for (int j = 0; j < this.numberOfRows; ++j) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.addSlot(new Slot(iinventory1, i1 + j * 9, 8 + i1 * 18, 18 + j * 18));
            }
        }
        for (int k = 0; k < 3; ++k) {
            for (int j1 = 0; j1 < 9; ++j1) {
                this.addSlot(new Slot(iinventory, j1 + k * 9 + 9, 8 + j1 * 18, 103 + k * 18 + i));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.addSlot(new Slot(iinventory, l, 8 + l * 18, 161 + i));
        }
    }

    @Override
    public boolean isUsableByPlayer(EntityPlayer entityplayer) {
        return this.field_20125_a.canInteractWith(entityplayer);
    }

    @Override
    public List<Integer> getMoveSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        int chestSize = this.numberOfRows * 9;
        if (slot.id >= 0 && slot.id < chestSize) {
            return this.getSlots(0, chestSize, false);
        }
        if (action == InventoryAction.MOVE_ALL) {
            if (slot.id >= chestSize && slot.id < chestSize + 27) {
                return this.getSlots(chestSize, 27, false);
            }
            if (slot.id >= chestSize + 27 && slot.id < chestSize + 36) {
                return this.getSlots(chestSize + 27, 9, false);
            }
        } else if (slot.id >= chestSize && slot.id < chestSize + 36) {
            return this.getSlots(chestSize, 36, false);
        }
        return null;
    }

    @Override
    public List<Integer> getTargetSlots(InventoryAction action, Slot slot, int target, EntityPlayer player) {
        int chestSize = this.numberOfRows * 9;
        if (slot.id < chestSize) {
            return this.getSlots(chestSize, 36, true);
        }
        return this.getSlots(0, chestSize, false);
    }
}

