/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.sound;

import java.util.HashMap;
import java.util.Map;

public class SoundTypes {
    public static final int MAX_SOUND_NAME_LENGTH = 64;
    private static Map<Integer, String> idToSoundNameMap = new HashMap<Integer, String>();
    private static Map<String, Integer> soundNameToIdMap = new HashMap<String, Integer>();
    private static int idCount = 0;

    public static void registerSounds() {
        SoundTypes.register("ambient.cave.cave");
        SoundTypes.register("ambient.weather.thunder");
        SoundTypes.register("ambient.weather.rain");
        SoundTypes.register("mob.skeleton");
        SoundTypes.register("mob.skeletonhurt");
        SoundTypes.register("mob.spider");
        SoundTypes.register("mob.spiderdeath");
        SoundTypes.register("mob.slime");
        SoundTypes.register("mob.slimeattack");
        SoundTypes.register("mob.ghast.charge");
        SoundTypes.register("mob.ghast.death");
        SoundTypes.register("mob.ghast.fireball");
        SoundTypes.register("mob.ghast.moan");
        SoundTypes.register("mob.ghast.scream");
        SoundTypes.register("mob.zombiepig.zpig");
        SoundTypes.register("mob.zombiepig.zpighurt");
        SoundTypes.register("mob.zombiepig.zpigdeath");
        SoundTypes.register("mob.zombie");
        SoundTypes.register("mob.zombiehurt");
        SoundTypes.register("mob.zombiedeath");
        SoundTypes.register("mob.chicken");
        SoundTypes.register("mob.chickenhurt");
        SoundTypes.register("mob.chickendeath");
        SoundTypes.register("mob.chickenplop");
        SoundTypes.register("mob.creeper");
        SoundTypes.register("mob.creeperdeath");
        SoundTypes.register("mob.pig");
        SoundTypes.register("mob.pigdeath");
        SoundTypes.register("mob.sheep");
        SoundTypes.register("mob.slime");
        SoundTypes.register("mob.cow");
        SoundTypes.register("mob.cowhurt");
        SoundTypes.register("mob.wolf");
        SoundTypes.register("mob.wolf.bark");
        SoundTypes.register("mob.wolf.hurt");
        SoundTypes.register("mob.wolf.shake");
        SoundTypes.register("mob.wolf.panting");
        SoundTypes.register("mob.wolf.death");
        SoundTypes.register("mob.wolf.whine");
        SoundTypes.register("mob.wolf.growl");
        SoundTypes.register("random.bow");
        SoundTypes.register("random.breath");
        SoundTypes.register("random.click");
        SoundTypes.register("random.drr");
        SoundTypes.register("random.door_open");
        SoundTypes.register("random.door_close");
        SoundTypes.register("random.explode");
        SoundTypes.register("random.fizz");
        SoundTypes.register("random.fuse");
        SoundTypes.register("random.hurt");
        SoundTypes.register("random.pop");
        SoundTypes.register("random.splash");
        SoundTypes.register("step.cloth");
        SoundTypes.register("step.grass");
        SoundTypes.register("step.gravel");
        SoundTypes.register("step.stone");
        SoundTypes.register("step.sand");
        SoundTypes.register("step.wood");
        SoundTypes.register("tile.piston.in");
        SoundTypes.register("tile.piston.out");
    }

    public static boolean register(String soundPath) {
        if (soundPath.length() > 64) {
            throw new RuntimeException("Sound Path is too long: '" + soundPath + "'!");
        }
        if (soundNameToIdMap.containsKey(soundPath)) {
            return false;
        }
        int id = idCount++;
        idCount %= 65536;
        soundNameToIdMap.put(soundPath, id);
        idToSoundNameMap.put(id, soundPath);
        return true;
    }

    public static int getSoundId(String soundPath) {
        Integer id = soundNameToIdMap.get(soundPath);
        if (id == null) {
            return -1;
        }
        return id;
    }

    public static String getSoundById(int id) {
        return idToSoundNameMap.get(id);
    }

    public static void setSoundIds(Map<String, Integer> soundIds) {
        idToSoundNameMap.clear();
        soundNameToIdMap.clear();
        for (Map.Entry<String, Integer> entry : soundIds.entrySet()) {
            int id = entry.getValue();
            String name = entry.getKey();
            idToSoundNameMap.put(id, name);
            soundNameToIdMap.put(name, id);
        }
    }

    public static Map<String, Integer> getSoundIds() {
        return new HashMap<String, Integer>(soundNameToIdMap);
    }
}

