/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.biome.data;

import net.minecraft.core.data.registry.Registries;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.data.BiomeRangeMap;

public class BiomeRangeLookup {
    private final byte[] lookup;
    private final int span;

    public BiomeRangeLookup(BiomeRangeMap map, int span) {
        this.lookup = new byte[span * span * span * span];
        this.span = span;
        for (int iTemperature = 0; iTemperature < span; ++iTemperature) {
            for (int iHumidity = 0; iHumidity < span; ++iHumidity) {
                for (int iAltitude = 0; iAltitude < span; ++iAltitude) {
                    for (int iVariety = 0; iVariety < span; ++iVariety) {
                        Biome biome = map.findBiome((double)iTemperature / (double)span, (double)iHumidity / (double)span, (double)iAltitude / (double)span, (double)iVariety / (double)span);
                        if (biome == null) {
                            throw new RuntimeException("Biome at T: " + (float)iTemperature / 50.0f + " H: " + (float)iHumidity / 50.0f + " A: " + (float)iAltitude / 50.0f + " V: " + (float)iVariety / 50.0f + " is null!");
                        }
                        this.setBiome(iTemperature, iHumidity, iAltitude, iVariety, biome);
                    }
                }
            }
        }
    }

    private void setBiome(int temperature, int humidity, int altitude, int variety, Biome biome) {
        this.lookup[variety * this.span * this.span * this.span + altitude * this.span * this.span + humidity * this.span + temperature] = (byte)Registries.BIOMES.getNumericIdOfItem(biome);
    }

    public Biome getBiome(double temperature, double humidity, double altitude, double variety) {
        int iTemperature = this.integerize(temperature);
        int iHumidity = this.integerize(humidity);
        int iAltitude = this.integerize(altitude);
        int iVariety = this.integerize(variety);
        return Registries.BIOMES.getItemByNumericId(this.lookup[iVariety * this.span * this.span * this.span + iAltitude * this.span * this.span + iHumidity * this.span + iTemperature]);
    }

    private int integerize(double d) {
        int i = (int)(d * (double)this.span);
        if (i < 0) {
            i = 0;
        }
        if (i >= this.span) {
            i = this.span - 1;
        }
        return i;
    }
}

