/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.generate.chunk;

import java.util.Arrays;
import net.minecraft.core.block.Block;
import net.minecraft.core.world.chunk.ChunkSection;

public class ChunkGeneratorResult {
    private final short[][] sectionBlocksArray = new short[16][];
    private final int[] numBlocksInSectionArray = new int[16];

    public ChunkGeneratorResult() {
        Arrays.fill(this.numBlocksInSectionArray, 0);
    }

    public void setBlock(int x, int y, int z, int id) {
        if (x < 0 || x >= 16 || y < 0 || y >= 256 || z < 0 || z >= 16) {
            return;
        }
        int section = y / 16;
        int cy = y % 16;
        Block newBlock = Block.getBlock(id);
        if (this.sectionBlocksArray[section] == null) {
            if (newBlock == null) {
                return;
            }
            this.sectionBlocksArray[section] = new short[4096];
        }
        Block currentBlock = Block.getBlock(this.getBlock(x, y, z));
        if (newBlock == null && currentBlock != null) {
            int n = section;
            this.numBlocksInSectionArray[n] = this.numBlocksInSectionArray[n] - 1;
        } else if (newBlock != null && currentBlock == null) {
            int n = section;
            this.numBlocksInSectionArray[n] = this.numBlocksInSectionArray[n] + 1;
        }
        this.sectionBlocksArray[section][ChunkSection.makeBlockIndex((int)x, (int)cy, (int)z)] = (short)id;
    }

    public int getBlock(int x, int y, int z) {
        if (x < 0 || x >= 16 || y < 0 || y >= 256 || z < 0 || z >= 16) {
            return 0;
        }
        int section = y / 16;
        int cy = y % 16;
        if (this.sectionBlocksArray[section] == null) {
            return 0;
        }
        return this.sectionBlocksArray[section][ChunkSection.makeBlockIndex(x, cy, z)];
    }

    public short[] getSectionBlocks(int ySection) {
        if (ySection < 0 || ySection >= 16) {
            return null;
        }
        if (this.numBlocksInSectionArray[ySection] <= 0) {
            return null;
        }
        return this.sectionBlocksArray[ySection];
    }
}

