/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.weather;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockLayerSnow;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biome;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.weather.Weather;

public class WeatherSnow
extends Weather {
    public WeatherSnow(int id) {
        super(id);
    }

    @Override
    public String getPrecipitationTexture(World world) {
        if (world.weatherManager.getWeatherPower() <= 0.6f) {
            return "/environment/snow_light.png";
        }
        return "/environment/snow.png";
    }

    @Override
    public void doChunkLoadEffect(World world, Chunk chunk) {
        if (world.weatherManager.getWeatherPower() <= 0.6f) {
            return;
        }
        for (int x = 0; x < 16; ++x) {
            int worldX = chunk.xPosition * 16 + x;
            block1: for (int z = 0; z < 16; ++z) {
                int y = chunk.getHeightValue(x, z);
                int worldZ = chunk.zPosition * 16 + z;
                Biome biome = world.getBlockBiome(worldX, y, worldZ);
                for (int i = 0; i < biome.blockedWeathers.length; ++i) {
                    if (biome.blockedWeathers[i] == this) continue block1;
                }
                int blockId = chunk.getBlockID(x, y, z);
                int blockIdBelow = chunk.getBlockID(x, y - 1, z);
                if (y < 0 || y >= world.getHeightBlocks() || chunk.getBrightness(LightLayer.Block, x, y, z) >= 10) continue;
                if (blockId == 0 && Block.layerSnow.canPlaceBlockAt(world, worldX, y, worldZ) && blockIdBelow != Block.ice.id) {
                    chunk.setBlockIDRaw(x, y, z, Block.layerSnow.id);
                    continue;
                }
                if (blockIdBelow != Block.fluidWaterStill.id || chunk.getBlockMetadata(x, y - 1, z) != 0) continue;
                chunk.setBlockIDRaw(x, y - 1, z, Block.ice.id);
                if (chunk.getBlockID(x, y - 2, z) != Block.fluidWaterStill.id) continue;
                chunk.setBlockIDRaw(x, y - 2, z, Block.fluidWaterFlowing.id);
            }
        }
    }

    @Override
    public void doEnvironmentUpdate(World world, Random rand, int x, int z) {
        block4: {
            int i;
            int blockIdBelow;
            int y;
            block6: {
                Biome biome;
                int blockId;
                boolean snow;
                block5: {
                    int probability = (int)(64.0f * (1.0f / world.weatherManager.getWeatherPower()));
                    if (world.getSeasonManager().getCurrentSeason() != null && world.getSeasonManager().getCurrentSeason().hasDeeperSnow) {
                        probability /= 2;
                    }
                    snow = rand.nextInt(probability) == 0;
                    y = world.findTopSolidBlock(x, z);
                    blockId = world.getBlockId(x, y, z);
                    blockIdBelow = world.getBlockId(x, y - 1, z);
                    biome = world.getBlockBiome(x, y, z);
                    for (i = 0; i < biome.blockedWeathers.length; ++i) {
                        if (biome.blockedWeathers[i] != this) continue;
                        return;
                    }
                    if (!(world.weatherManager.getWeatherPower() > 0.6f) || y < 0 || y >= world.getHeightBlocks() || world.getSavedLightValue(LightLayer.Block, x, y, z) >= 10) break block4;
                    if (blockId != 0 || blockIdBelow == 0 || !Block.layerSnow.canPlaceBlockAt(world, x, y, z) || blockIdBelow == Block.ice.id) break block5;
                    if (!snow) break block4;
                    world.setBlockWithNotify(x, y, z, Block.layerSnow.id);
                    break block4;
                }
                if (!(world.weatherManager.getWeatherPower() > 0.5f) || blockId != Block.layerSnow.id || world.getSeasonManager().getCurrentSeason() == null || !world.getSeasonManager().getCurrentSeason().hasDeeperSnow && biome != Biomes.OVERWORLD_GLACIER) break block6;
                if (!snow) break block4;
                ((BlockLayerSnow)Block.layerSnow).accumulate(world, x, y, z);
                break block4;
            }
            if (blockIdBelow == Block.fluidWaterStill.id && world.getBlockMetadata(x, y - 1, z) == 0 && rand.nextFloat() < world.weatherManager.getWeatherPower() * world.weatherManager.getWeatherIntensity()) {
                for (i = 0; i < 4; ++i) {
                    Direction direction = Direction.horizontalDirections[i];
                    Block block = world.getBlock(x + direction.getOffsetX(), y - 1, z + direction.getOffsetZ());
                    if (block != Block.ice && (block == null || !block.isSolidRender())) continue;
                    world.setBlockWithNotify(x, y - 1, z, Block.ice.id);
                    break;
                }
            }
        }
    }
}

