/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.server.entity;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.EntityLiving;
import net.minecraft.core.entity.player.EntityPlayer;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.net.entity.NetEntityHandler;
import net.minecraft.core.net.packet.Packet;
import net.minecraft.core.net.packet.Packet17Sleep;
import net.minecraft.core.net.packet.Packet28EntityVelocity;
import net.minecraft.core.net.packet.Packet29DestroyEntity;
import net.minecraft.core.net.packet.Packet31RelEntityMove;
import net.minecraft.core.net.packet.Packet32EntityLook;
import net.minecraft.core.net.packet.Packet33RelEntityMoveLook;
import net.minecraft.core.net.packet.Packet34EntityTeleport;
import net.minecraft.core.net.packet.Packet35EntityNickname;
import net.minecraft.core.net.packet.Packet40EntityMetadata;
import net.minecraft.core.net.packet.Packet42EntityTagData;
import net.minecraft.core.net.packet.Packet5PlayerInventory;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.data.SynchedEntityData;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class EntityTrackerEntry {
    public Entity trackedEntity;
    public int trackingDistance;
    public int packetDelay;
    public int encodedPosX;
    public int encodedPosY;
    public int encodedPosZ;
    public int encodedRotationYaw;
    public int encodedRotationPitch;
    public double lastTrackedEntityMotionX;
    public double lastTrackedEntityMotionY;
    public double lastTrackedEntityMotionZ;
    public int updateCounter = 0;
    private double lastTrackedEntityPosX;
    private double lastTrackedEntityPosY;
    private double lastTrackedEntityPosZ;
    private boolean firstUpdateDone = false;
    private final boolean shouldSendMotionUpdates;
    private int ticksSinceLastTeleport = 0;
    public boolean playerEntitiesUpdated = false;
    public Set<EntityPlayerMP> trackedPlayers = new HashSet<EntityPlayerMP>();

    public EntityTrackerEntry(Entity entity, int trackingDistance, int packetDelay, boolean shouldSendMotionUpdates) {
        this.trackedEntity = entity;
        this.trackingDistance = trackingDistance;
        this.packetDelay = packetDelay;
        this.shouldSendMotionUpdates = shouldSendMotionUpdates;
        this.encodedPosX = MathHelper.floor_double(entity.x * 32.0);
        this.encodedPosY = MathHelper.floor_double(entity.y * 32.0);
        this.encodedPosZ = MathHelper.floor_double(entity.z * 32.0);
        this.encodedRotationYaw = MathHelper.floor_float(entity.yRot * 256.0f / 360.0f);
        this.encodedRotationPitch = MathHelper.floor_float(entity.xRot * 256.0f / 360.0f);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof EntityTrackerEntry)) {
            return false;
        }
        return ((EntityTrackerEntry)obj).trackedEntity.id == this.trackedEntity.id;
    }

    public int hashCode() {
        return this.trackedEntity.id;
    }

    public void tick(List<EntityPlayer> list) {
        this.playerEntitiesUpdated = false;
        if (!this.firstUpdateDone || this.trackedEntity.distanceToSqr(this.lastTrackedEntityPosX, this.lastTrackedEntityPosY, this.lastTrackedEntityPosZ) > 16.0) {
            this.lastTrackedEntityPosX = this.trackedEntity.x;
            this.lastTrackedEntityPosY = this.trackedEntity.y;
            this.lastTrackedEntityPosZ = this.trackedEntity.z;
            this.firstUpdateDone = true;
            this.playerEntitiesUpdated = true;
            this.updatePlayerEntities(list);
        }
        ++this.ticksSinceLastTeleport;
        if (++this.updateCounter % this.packetDelay == 0) {
            SynchedEntityData synchedEntityData;
            double d3;
            double d2;
            double d1;
            double d;
            double d4;
            boolean hasLooked;
            int entityX = MathHelper.floor_double(this.trackedEntity.x * 32.0);
            int entityY = MathHelper.floor_double(this.trackedEntity.y * 32.0);
            int entityZ = MathHelper.floor_double(this.trackedEntity.z * 32.0);
            int entityYaw = MathHelper.floor_float(this.trackedEntity.yRot * 256.0f / 360.0f);
            int entityPitch = MathHelper.floor_float(this.trackedEntity.xRot * 256.0f / 360.0f);
            int dx = entityX - this.encodedPosX;
            int dy = entityY - this.encodedPosY;
            int dz = entityZ - this.encodedPosZ;
            Packet packet = null;
            boolean hasMoved = Math.abs(entityX) >= 8 || Math.abs(entityY) >= 8 || Math.abs(entityZ) >= 8;
            boolean bl = hasLooked = Math.abs(entityYaw - this.encodedRotationYaw) >= 8 || Math.abs(entityPitch - this.encodedRotationPitch) >= 8;
            if (dx < -128 || dx >= 128 || dy < -128 || dy >= 128 || dz < -128 || dz >= 128 || this.ticksSinceLastTeleport > 400) {
                this.ticksSinceLastTeleport = 0;
                this.trackedEntity.x = (double)entityX / 32.0;
                this.trackedEntity.y = (double)entityY / 32.0;
                this.trackedEntity.z = (double)entityZ / 32.0;
                packet = new Packet34EntityTeleport(this.trackedEntity.id, entityX, entityY, entityZ, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved && hasLooked) {
                packet = new Packet33RelEntityMoveLook(this.trackedEntity.id, (byte)dx, (byte)dy, (byte)dz, (byte)entityYaw, (byte)entityPitch);
            } else if (hasMoved) {
                packet = new Packet31RelEntityMove(this.trackedEntity.id, (byte)dx, (byte)dy, (byte)dz);
            } else if (hasLooked) {
                packet = new Packet32EntityLook(this.trackedEntity.id, (byte)entityYaw, (byte)entityPitch);
            }
            if (this.shouldSendMotionUpdates && ((d4 = (d = this.trackedEntity.xd - this.lastTrackedEntityMotionX) * d + (d1 = this.trackedEntity.yd - this.lastTrackedEntityMotionY) * d1 + (d2 = this.trackedEntity.zd - this.lastTrackedEntityMotionZ) * d2) > (d3 = 0.02) * d3 || d4 > 0.0 && this.trackedEntity.xd == 0.0 && this.trackedEntity.yd == 0.0 && this.trackedEntity.zd == 0.0)) {
                this.lastTrackedEntityMotionX = this.trackedEntity.xd;
                this.lastTrackedEntityMotionY = this.trackedEntity.yd;
                this.lastTrackedEntityMotionZ = this.trackedEntity.zd;
                this.sendPacketToTrackedPlayers(new Packet28EntityVelocity(this.trackedEntity.id, this.lastTrackedEntityMotionX, this.lastTrackedEntityMotionY, this.lastTrackedEntityMotionZ));
            }
            if (packet != null) {
                this.sendPacketToTrackedPlayers(packet);
            }
            if ((synchedEntityData = this.trackedEntity.getEntityData()).isDirty()) {
                this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet40EntityMetadata(this.trackedEntity.id, synchedEntityData));
            }
            if (hasMoved) {
                this.encodedPosX = entityX;
                this.encodedPosY = entityY;
                this.encodedPosZ = entityZ;
            }
            if (hasLooked) {
                this.encodedRotationYaw = entityYaw;
                this.encodedRotationPitch = entityPitch;
            }
        }
        if (this.trackedEntity.hurtMarked) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet28EntityVelocity(this.trackedEntity));
            this.trackedEntity.hurtMarked = false;
        }
        if (this.trackedEntity.hadNicknameSet) {
            this.sendPacketToTrackedPlayersAndTrackedEntity(new Packet35EntityNickname(this.trackedEntity.id, ((EntityLiving)this.trackedEntity).nickname, ((EntityLiving)this.trackedEntity).chatColor));
            this.trackedEntity.hadNicknameSet = false;
        }
    }

    public void sendPacketToTrackedPlayers(Packet packet) {
        for (EntityPlayerMP playerMP : this.trackedPlayers) {
            playerMP.playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendPacketToTrackedPlayersAndTrackedEntity(Packet packet) {
        this.sendPacketToTrackedPlayers(packet);
        if (this.trackedEntity instanceof EntityPlayerMP) {
            ((EntityPlayerMP)this.trackedEntity).playerNetServerHandler.sendPacket(packet);
        }
    }

    public void sendDestroyEntityPacketToTrackedPlayers() {
        this.sendPacketToTrackedPlayers(new Packet29DestroyEntity(this.trackedEntity.id));
    }

    public void removeFromTrackedPlayers(EntityPlayerMP playerMP) {
        this.trackedPlayers.remove(playerMP);
    }

    public void updatePlayerEntity(EntityPlayerMP entityplayermp) {
        if (entityplayermp == this.trackedEntity) {
            return;
        }
        double dx = entityplayermp.x - (double)(this.encodedPosX / 32);
        double dz = entityplayermp.z - (double)(this.encodedPosZ / 32);
        if (dx >= (double)(-this.trackingDistance) && dx <= (double)this.trackingDistance && dz >= (double)(-this.trackingDistance) && dz <= (double)this.trackingDistance) {
            if (!this.trackedPlayers.contains(entityplayermp)) {
                EntityPlayer entityplayer;
                ItemStack[] aitemstack;
                this.trackedPlayers.add(entityplayermp);
                entityplayermp.playerNetServerHandler.sendPacket(NetEntityHandler.getSpawnPacket(this));
                if (this.trackedEntity.sendAdditionalData) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet42EntityTagData(this.trackedEntity));
                }
                if (this.shouldSendMotionUpdates) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet28EntityVelocity(this.trackedEntity.id, this.trackedEntity.xd, this.trackedEntity.yd, this.trackedEntity.zd));
                }
                if ((aitemstack = this.trackedEntity.getInventory()) != null) {
                    for (int i = 0; i < aitemstack.length; ++i) {
                        entityplayermp.playerNetServerHandler.sendPacket(new Packet5PlayerInventory(this.trackedEntity.id, i, aitemstack[i]));
                    }
                }
                if (this.trackedEntity instanceof EntityPlayer && (entityplayer = (EntityPlayer)this.trackedEntity).isPlayerSleeping()) {
                    entityplayermp.playerNetServerHandler.sendPacket(new Packet17Sleep(this.trackedEntity, 0, MathHelper.floor_double(this.trackedEntity.x), MathHelper.floor_double(this.trackedEntity.y), MathHelper.floor_double(this.trackedEntity.z)));
                }
            }
        } else if (this.trackedPlayers.contains(entityplayermp)) {
            this.trackedPlayers.remove(entityplayermp);
            entityplayermp.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.id));
        }
    }

    public void updatePlayerEntities(List<EntityPlayer> list) {
        for (EntityPlayer player : list) {
            this.updatePlayerEntity((EntityPlayerMP)player);
        }
    }

    public void removeTrackedPlayerSymmetric(EntityPlayerMP playerMP) {
        if (this.trackedPlayers.contains(playerMP)) {
            this.trackedPlayers.remove(playerMP);
            playerMP.playerNetServerHandler.sendPacket(new Packet29DestroyEntity(this.trackedEntity.id));
        }
    }
}

