/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.fx;

import net.minecraft.client.entity.fx.EntityFX;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.world.World;

public class EntityHeartFX
extends EntityFX {
    float field_25022_a;

    public EntityHeartFX(World world, double d, double d1, double d2, double d3, double d4, double d5) {
        this(world, d, d1, d2, d3, d4, d5, 2.0f);
    }

    public EntityHeartFX(World world, double d, double d1, double d2, double d3, double d4, double d5, float f) {
        super(world, d, d1, d2, 0.0, 0.0, 0.0);
        this.xd *= 0.01;
        this.yd *= 0.01;
        this.zd *= 0.01;
        this.yd += 0.1;
        this.particleScale *= 0.75f;
        this.particleScale *= f;
        this.field_25022_a = this.particleScale;
        this.particleMaxAge = 16;
        this.noPhysics = false;
        this.particleTexture = TextureRegistry.getTexture("minecraft:particle/heart");
    }

    @Override
    public void renderParticle(Tessellator t, float partialTick, float rotationX, float rotationXZ, float rotationZ, float rotationYZ, float rotationXY) {
        float f6 = ((float)this.particleAge + partialTick) / (float)this.particleMaxAge * 32.0f;
        if (f6 < 0.0f) {
            f6 = 0.0f;
        }
        if (f6 > 1.0f) {
            f6 = 1.0f;
        }
        this.particleScale = this.field_25022_a * f6;
        super.renderParticle(t, partialTick, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
    }

    @Override
    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        if (this.particleAge++ >= this.particleMaxAge) {
            this.remove();
        }
        this.move(this.xd, this.yd, this.zd);
        if (this.y == this.yo) {
            this.xd *= 1.1;
            this.zd *= 1.1;
        }
        this.xd *= 0.86;
        this.yd *= 0.86;
        this.zd *= 0.86;
        if (this.onGround) {
            this.xd *= 0.7;
            this.zd *= 0.7;
        }
    }
}

