/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.BlockModelChest;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockChest;
import net.minecraft.core.item.ItemDye;
import net.minecraft.core.util.helper.Axis;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelChestPainted<T extends Block>
extends BlockModelChest<T> {
    public static final IconCoordinate[][] texCoords = new IconCoordinate[16][];

    public BlockModelChestPainted(Block block) {
        super(block, "minecraft:block/chest_planks_oak");
    }

    @Override
    public IconCoordinate getBlockTexture(WorldSource blockAccess, int x, int y, int z, Side side) {
        int meta = blockAccess.getBlockMetadata(x, y, z);
        int color = meta >> 4;
        if (side == Side.TOP || side == Side.BOTTOM) {
            return texCoords[color][6];
        }
        Side facing = BlockChest.getDirectionFromMeta(meta).getSide();
        BlockChest.Type type = BlockChest.getTypeFromMeta(meta);
        if (type == BlockChest.Type.SINGLE && side == facing) {
            return texCoords[color][0];
        }
        if (type == BlockChest.Type.LEFT) {
            if (side == facing) {
                return texCoords[color][1];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][4];
            }
        }
        if (type == BlockChest.Type.RIGHT) {
            if (side == facing) {
                return texCoords[color][2];
            }
            if (side == facing.getOpposite()) {
                return texCoords[color][3];
            }
        }
        if (side.getAxis() != Axis.Y) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        int color = data >> 4;
        if (side == Side.SOUTH) {
            return texCoords[color][0];
        }
        if (side.isHorizontal()) {
            return texCoords[color][5];
        }
        return texCoords[color][6];
    }

    static {
        for (int i = 0; i < 16; ++i) {
            String rootKey = "minecraft:block/chest_planks_oak_painted_" + ItemDye.dyeColors[15 - i];
            BlockModelChestPainted.texCoords[i] = new IconCoordinate[7];
            BlockModelChestPainted.texCoords[i][0] = TextureRegistry.getTexture(rootKey + "_front");
            BlockModelChestPainted.texCoords[i][1] = TextureRegistry.getTexture(rootKey + "_left_front");
            BlockModelChestPainted.texCoords[i][2] = TextureRegistry.getTexture(rootKey + "_right_front");
            BlockModelChestPainted.texCoords[i][3] = TextureRegistry.getTexture(rootKey + "_left_back");
            BlockModelChestPainted.texCoords[i][4] = TextureRegistry.getTexture(rootKey + "_right_back");
            BlockModelChestPainted.texCoords[i][5] = TextureRegistry.getTexture(rootKey + "_side");
            BlockModelChestPainted.texCoords[i][6] = TextureRegistry.getTexture(rootKey + "_top");
        }
    }
}

