/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.block.model.BlockModelStandard;
import net.minecraft.client.render.stitcher.IconCoordinate;
import net.minecraft.client.render.stitcher.TextureRegistry;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.BlockRail;
import net.minecraft.core.enums.LightLayer;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class BlockModelRail<T extends BlockRail>
extends BlockModelStandard<T> {
    protected IconCoordinate railCurve = TextureRegistry.getTexture("minecraft:block/rail_turn");
    protected IconCoordinate powerActive = TextureRegistry.getTexture("minecraft:block/rail_powered_active");
    protected IconCoordinate powerActiveOverlay = TextureRegistry.getTexture("minecraft:block/rail_powered_overlay");

    public BlockModelRail(Block block) {
        super(block);
        this.hasOverbright = true;
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        ((BlockRail)this.block).setBlockBoundsBasedOnState(BlockModelRail.renderBlocks.blockAccess, x, y, z);
        int l = BlockModelRail.renderBlocks.blockAccess.getBlockMetadata(x, y, z);
        IconCoordinate i1 = this.getBlockTextureFromSideAndMetadata(Side.BOTTOM, l);
        if (BlockModelRail.renderBlocks.overrideBlockTexture != null) {
            i1 = BlockModelRail.renderBlocks.overrideBlockTexture;
        }
        if (((BlockRail)this.block).getIsPowered()) {
            l &= 7;
        }
        float brightness = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            if (BlockModelRail.renderBlocks.overbright) {
                tessellator.setLightmapCoord(LightmapHelper.getOverbrightLightmapCoord(BlockModelRail.renderBlocks.blockAccess.getSavedLightValue(LightLayer.Sky, x, y, z)));
            } else {
                tessellator.setLightmapCoord(((BlockRail)this.block).getLightmapCoord(BlockModelRail.renderBlocks.blockAccess, x, y, z));
            }
        } else if (!BlockModelRail.renderBlocks.overbright) {
            brightness = this.getBlockBrightness(BlockModelRail.renderBlocks.blockAccess, x, y, z);
        }
        if (BlockModelRail.renderBlocks.overbright && (i1 = this.getBlockOverbrightTexture(BlockModelRail.renderBlocks.blockAccess, x, y, z, 0)) == null) {
            return false;
        }
        tessellator.setColorOpaque_F(brightness, brightness, brightness);
        double d = i1.getIconUMin();
        double d1 = i1.getIconUMax();
        double d2 = i1.getIconVMin();
        double d3 = i1.getIconVMax();
        float f1 = 0.0625f;
        float f2 = x + 1;
        float f3 = x + 1;
        float f4 = x;
        float f5 = x;
        float f6 = z;
        float f7 = z + 1;
        float f8 = z + 1;
        float f9 = z;
        float f10 = (float)y + f1;
        float f11 = (float)y + f1;
        float f12 = (float)y + f1;
        float f13 = (float)y + f1;
        if (l == 1 || l == 2 || l == 3 || l == 7) {
            f2 = f5 = (float)(x + 1);
            f3 = f4 = (float)x;
            f6 = f7 = (float)(z + 1);
            f8 = f9 = (float)z;
        } else if (l == 8) {
            f2 = f3 = (float)x;
            f4 = f5 = (float)(x + 1);
            f6 = f9 = (float)(z + 1);
            f7 = f8 = (float)z;
        } else if (l == 9) {
            f2 = f5 = (float)x;
            f3 = f4 = (float)(x + 1);
            f6 = f7 = (float)z;
            f8 = f9 = (float)(z + 1);
        }
        if (l == 2 || l == 4) {
            f10 += 1.0f;
            f13 += 1.0f;
        } else if (l == 3 || l == 5) {
            f11 += 1.0f;
            f12 += 1.0f;
        }
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f5, f13, f9, d, d2);
        tessellator.addVertexWithUV(f4, f12, f8, d, d3);
        tessellator.addVertexWithUV(f3, f11, f7, d1, d3);
        tessellator.addVertexWithUV(f2, f10, f6, d1, d2);
        return true;
    }

    @Override
    public boolean shouldItemRender3d() {
        return false;
    }

    @Override
    public IconCoordinate getBlockOverbrightTexture(WorldSource blockAccess, int x, int y, int z, int side) {
        if (((BlockRail)this.block).id != Block.railPowered.id || (blockAccess.getBlockMetadata(x, y, z) & 8) == 0) {
            return null;
        }
        return this.powerActiveOverlay;
    }

    @Override
    public IconCoordinate getBlockTextureFromSideAndMetadata(Side side, int data) {
        if (((BlockRail)this.block).isPowered && (data & 8) != 0) {
            return this.powerActive;
        }
        if (!((BlockRail)this.block).isPowered && data >= 6) {
            return this.railCurve;
        }
        return super.getBlockTextureFromSideAndMetadata(side, data);
    }
}

