/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.net.command.commands;

import net.minecraft.core.net.command.CommandHandler;
import net.minecraft.core.net.command.CommandSender;
import net.minecraft.core.net.command.ServerCommand;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.Packet72UpdatePlayerProfile;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.entity.player.EntityPlayerMP;

public class DeopCommand
extends ServerCommand {
    public DeopCommand(MinecraftServer server) {
        super(server, "deop", new String[0]);
    }

    @Override
    public boolean execute(CommandHandler handler, CommandSender sender, String[] args) {
        EntityPlayerMP player;
        if (args.length == 0) {
            return false;
        }
        String name = args[0];
        boolean playerWasOp = this.server.playerList.isOp(name);
        this.server.playerList.deopPlayer(name);
        if (playerWasOp) {
            handler.sendCommandFeedback(sender, "De-opping " + name);
        }
        if ((player = (EntityPlayerMP)handler.getPlayer(name)) != null && playerWasOp) {
            handler.sendMessageToPlayer(player, TextFormatting.YELLOW + "You are no longer op!");
            player.mcServer.playerList.sendPacketToAllPlayers(new Packet72UpdatePlayerProfile(player.username, player.nickname, player.score, player.chatColor, true, player.isOperator()));
        }
        return true;
    }

    @Override
    public boolean opRequired(String[] args) {
        return true;
    }

    @Override
    public void sendCommandSyntax(CommandHandler handler, CommandSender sender) {
        sender.sendMessage("/deop <Player>");
    }
}

