/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.world.type;

import net.minecraft.core.block.Block;
import net.minecraft.core.world.World;
import net.minecraft.core.world.biome.Biomes;
import net.minecraft.core.world.biome.provider.BiomeProvider;
import net.minecraft.core.world.biome.provider.BiomeProviderSingleBiome;
import net.minecraft.core.world.config.season.SeasonConfig;
import net.minecraft.core.world.generate.chunk.ChunkGenerator;
import net.minecraft.core.world.generate.chunk.perlin.overworld.hell.ChunkGeneratorOverworldHell;
import net.minecraft.core.world.season.Seasons;
import net.minecraft.core.world.type.WorldTypeOverworld;
import net.minecraft.core.world.weather.Weather;
import net.minecraft.core.world.wind.WindManagerGeneric;

public class WorldTypeOverworldHell
extends WorldTypeOverworld {
    public WorldTypeOverworldHell(String languageKey) {
        super(languageKey, Weather.overworldRainBlood, new WindManagerGeneric(), SeasonConfig.builder().withSingleSeason(Seasons.OVERWORLD_HELL).build());
    }

    @Override
    public void onWorldCreation(World world) {
        super.onWorldCreation(world);
        world.setWorldTime(576000L);
    }

    @Override
    public int getMinY() {
        return 0;
    }

    @Override
    public int getMaxY() {
        return 127;
    }

    @Override
    public int getOceanY() {
        return 64;
    }

    @Override
    public int getOceanBlock() {
        return Block.fluidLavaStill.id;
    }

    @Override
    public BiomeProvider createBiomeProvider(World world) {
        return new BiomeProviderSingleBiome(Biomes.OVERWORLD_HELL, 1.0, 1.0, 0.0);
    }

    @Override
    public ChunkGenerator createChunkGenerator(World world) {
        return new ChunkGeneratorOverworldHell(world);
    }

    @Override
    public float getCelestialAngle(World world, long tick, float partialTick) {
        return 0.5f;
    }

    @Override
    public float getCloudHeight() {
        return 108.0f;
    }

    @Override
    public boolean hasAurora() {
        return false;
    }
}

