/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.entity.particle;

import net.minecraft.client.entity.particle.Particle;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.client.render.texture.stitcher.TextureRegistry;
import net.minecraft.core.entity.animal.FireflyClusterMob;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.world.World;

public class FireflyParticle
extends Particle {
    float oSize;
    float sinTimer = 0.0f;
    boolean isReversed = false;
    float midR = 0.0f;
    float midG = 0.0f;
    float midB = 0.0f;
    final float minR = 0.3764706f;
    final float minG = 0.21176471f;
    final float minB = 0.0f;
    float maxR = 0.9411765f;
    float maxG = 1.0f;
    float maxB = 0.6784314f;
    float oR;
    float oG;
    float oB;

    public FireflyParticle(World world, double x, double y, double z, double xa, double ya, double za, int type) {
        this(world, x, y, z, xa, ya, za, 1.0f, type);
    }

    public FireflyParticle(World world, double x, double y, double z, double xa, double ya, double za, float scale, int type) {
        super(world, x, y, z, 0.0, 0.0, 0.0);
        this.xd = 0.01;
        this.yd = 0.01;
        this.zd = 0.01;
        this.xd += xa;
        this.yd += ya;
        this.zd += za;
        this.setColor(type);
        this.oSize = this.size = 2.0f;
        this.lifetime = (int)(24.0 + (double)this.random.nextInt(6));
        this.lifetime *= (int)scale;
        this.noPhysics = false;
        this.tex = TextureRegistry.getTexture("minecraft:particle/firefly");
        if (this.random.nextInt(2) == 0) {
            this.isReversed = true;
        }
        this.oR = this.random.nextFloat() * 0.06f - 0.03f;
        this.oG = this.random.nextFloat() * 0.06f - 0.03f;
        this.oB = this.random.nextFloat() * 0.06f - 0.03f;
    }

    private void setColor(int type) {
        float[] color = FireflyClusterMob.FireflyColor.fireFlyColors.get(type).getMidColor();
        this.midR = color[0];
        this.midG = color[1];
        this.midB = color[2];
        this.rCol = this.midR;
        this.gCol = this.midG;
        this.bCol = this.midB;
        this.maxR = MathHelper.clamp(this.midR + 0.25f, 0.0f, 1.0f);
        this.maxG = MathHelper.clamp(this.midG + 0.25f, 0.0f, 1.0f);
        this.maxB = MathHelper.clamp(this.midB + 0.25f, 0.0f, 1.0f);
    }

    public void setAge(int age) {
        this.age = age;
    }

    @Override
    public float getBrightness(float partialTick) {
        float internalBrightness = this.getInternalBrightness(partialTick);
        float worldBrightness = super.getBrightness(partialTick);
        return Math.max(internalBrightness, worldBrightness);
    }

    public float getInternalBrightness(float partialTick) {
        float b = (float)(Math.sin((float)this.age * 0.25f) + 1.0) / 2.0f;
        return MathHelper.clamp(b, 0.0f, 1.0f);
    }

    @Override
    public void render(Tessellator t, float partialTick, float xa, float ya, float za, float xa2, float za2) {
        float ibr = this.getInternalBrightness(partialTick);
        if (ibr < 0.5f) {
            this.rCol = MathHelper.lerp(this.minR, this.midR, ibr * 2.0f);
            this.gCol = MathHelper.lerp(this.minG, this.midG, ibr * 2.0f);
            this.bCol = MathHelper.lerp(this.minB, this.midB, ibr * 2.0f);
        } else {
            this.rCol = MathHelper.lerp(this.midR, this.maxR, (ibr - 0.5f) * 2.0f);
            this.gCol = MathHelper.lerp(this.midG, this.maxG, (ibr - 0.5f) * 2.0f);
            this.bCol = MathHelper.lerp(this.midB, this.maxB, (ibr - 0.5f) * 2.0f);
        }
        this.rCol += this.oR;
        this.gCol += this.oG;
        this.bCol += this.oB;
        super.render(t, partialTick, xa, ya, za, xa2, za2);
    }

    public void renderParticleInGui(Tessellator t, float partialTick) {
        float ibr = this.getInternalBrightness(partialTick);
        if (ibr < 0.5f) {
            this.rCol = MathHelper.lerp(this.minR, this.midR, ibr * 2.0f);
            this.gCol = MathHelper.lerp(this.minG, this.midG, ibr * 2.0f);
            this.bCol = MathHelper.lerp(this.minB, this.midB, ibr * 2.0f);
        } else {
            this.rCol = MathHelper.lerp(this.midR, this.maxR, (ibr - 0.5f) * 2.0f);
            this.gCol = MathHelper.lerp(this.midG, this.maxG, (ibr - 0.5f) * 2.0f);
            this.bCol = MathHelper.lerp(this.midB, this.maxB, (ibr - 0.5f) * 2.0f);
        }
        this.rCol += this.oR;
        this.gCol += this.oG;
        this.bCol += this.oB;
        float u0 = (float)this.tex.getIconUMin();
        float u2 = (float)this.tex.getSubIconU(0.0625);
        float v0 = (float)this.tex.getIconVMin();
        float v2 = (float)this.tex.getSubIconV(0.0625);
        float r = 0.1f * this.size;
        float x = (float)(this.xo + (this.x - this.xo) * (double)partialTick);
        float y = (float)(this.yo + (this.y - this.yo) * (double)partialTick);
        float br = 1.0f;
        if (LightmapHelper.isLightmapEnabled()) {
            t.setLightmapCoord(this.getLightmapCoord(partialTick));
        } else {
            br = this.getBrightness(partialTick);
        }
        t.setColorOpaque_F(this.rCol * br, this.gCol * br, this.bCol * br);
        t.addVertexWithUV(x + r, y - r, 0.0, u2, v2);
        t.addVertexWithUV(x + r, y + r, 0.0, u2, v0);
        t.addVertexWithUV(x - r, y + r, 0.0, u0, v0);
        t.addVertexWithUV(x - r, y - r, 0.0, u0, v2);
    }

    @Override
    public int getLightmapCoord(float partialTick) {
        return LightmapHelper.setBlocklightValue(super.getLightmapCoord(partialTick), 15);
    }

    public void tickGui() {
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.age++ >= this.lifetime && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.yd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
        }
        this.move(this.xd, this.yd, 0.0);
    }

    @Override
    public void tick() {
        this.sinTimer += 1.0f;
        if (this.sinTimer > 100.0f) {
            this.sinTimer = 0.0f;
        }
        if (this.age++ >= this.lifetime && this.getInternalBrightness(1.0f) < 0.01f) {
            this.remove();
        }
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.xd = MathHelper.sin(this.sinTimer * 0.15f) / 60.0f;
        this.zd = MathHelper.cos(this.sinTimer * 0.15f) / 60.0f;
        if (this.isReversed) {
            this.xd = -this.xd;
            this.yd = -this.yd;
            this.zd = -this.zd;
        }
        this.move(this.xd, this.yd, this.zd);
    }
}

