/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiChatEmotePicker;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSleepMP;
import net.minecraft.client.gui.text.ITextField;
import net.minecraft.client.gui.text.TextFieldEditor;
import net.minecraft.core.net.ChatEmotes;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiChat
extends GuiScreen
implements ITextField {
    protected String message;
    private int currentIndex = 0;
    private String originalMessage;
    private int updateCounter;
    private final TextFieldEditor editor;
    protected GuiChatEmotePicker emotePicker;
    protected boolean showEmotePicker = false;

    public GuiChat() {
        this("");
    }

    public GuiChat(String initialMessage) {
        this.message = initialMessage;
        this.updateCounter = 0;
        this.editor = new TextFieldEditor(this);
        this.editor.setCursor(10000);
    }

    @Override
    public void init() {
        Keyboard.enableRepeatEvents(true);
        int emotePickerYCells = (int)MathHelper.clamp(Math.ceil((double)ChatEmotes.getEmotes().size() / 5.0), 0.0, 4.0);
        this.emotePicker = new GuiChatEmotePicker(this.mc, this, 5, emotePickerYCells);
        this.showEmotePicker = false;
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents(false);
        this.mc.ingameGUI.chatScroll = 0;
    }

    @Override
    public void tick() {
        ++this.updateCounter;
        int dWheel = Mouse.getDWheel();
        if (dWheel != 0) {
            if (this.showEmotePicker) {
                this.emotePicker.scrollOffset((int)((float)(-dWheel) / 0.1f));
            } else {
                this.mc.ingameGUI.chatScroll += dWheel / 1;
            }
        }
    }

    @Override
    public void keyTyped(char c, int key, int mouseX, int mouseY) {
        if (key == Keyboard.KEY_UP && this.mc.thePlayer.messageHistory.size() > 0) {
            if (this.currentIndex == 0) {
                this.originalMessage = this.getText();
            }
            if (this.currentIndex < this.mc.thePlayer.messageHistory.size()) {
                ++this.currentIndex;
                this.setText(this.getMessage(this.currentIndex));
                this.editor.setCursor(10000);
            }
            this.editor.setCursor(10000);
            return;
        }
        if (key == Keyboard.KEY_DOWN && this.currentIndex > 0) {
            if (this.currentIndex - 1 == 0) {
                --this.currentIndex;
                this.setText(this.originalMessage);
                this.editor.setCursor(10000);
            } else {
                --this.currentIndex;
                this.setText(this.getMessage(this.currentIndex));
                this.editor.setCursor(10000);
            }
            this.editor.setCursor(10000);
            return;
        }
        if (key == Keyboard.KEY_ESCAPE && !(this instanceof GuiSleepMP)) {
            this.mc.displayGuiScreen(null);
            return;
        }
        if (key == Keyboard.KEY_RETURN) {
            String s = this.message.trim();
            if (s.length() > 0) {
                String s1 = this.message.trim();
                this.mc.thePlayer.sendChatMessage(s1);
            }
            this.mc.displayGuiScreen(null);
            return;
        }
        this.editor.handleInput(key, c);
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        int emotePickerButtonColor = Integer.MIN_VALUE;
        int emotePickerTextColor = 0xE0E0E0;
        if (mouseX >= 2 && mouseX < 14 && mouseY >= this.height - 14 && mouseY < this.height - 2) {
            emotePickerButtonColor = -2130706433;
            emotePickerTextColor = -96;
        }
        this.drawRect(2, this.height - 14, 14, this.height - 2, emotePickerButtonColor);
        this.drawStringCentered(this.fontRenderer, Character.toString('\u263a'), 8, this.height - 12, emotePickerTextColor);
        this.drawRect(16, this.height - 14, this.width - 2, this.height - 2, Integer.MIN_VALUE);
        boolean drawCursor = this.updateCounter / 6 % 2 == 0;
        int cursor = this.editor.getCursor();
        this.drawString(this.fontRenderer, this.message, 18, this.height - 12, 0xE0E0E0);
        if (drawCursor) {
            int width = this.fontRenderer.getStringWidth(this.message);
            if (cursor < this.message.length()) {
                width = this.fontRenderer.getStringWidth(this.message.substring(0, cursor));
            }
            this.drawString(this.fontRenderer, "_", 18 + width, this.height - 12, 0xE0E0E0);
        }
        if (this.showEmotePicker) {
            this.emotePicker.draw(2, this.height - 16 - this.emotePicker.getHeight(), mouseX, mouseY);
        }
        super.drawScreen(mouseX, mouseY, partialTick);
    }

    @Override
    public void mouseClicked(int mouseX, int mouseY, int mouseButton) {
        super.mouseClicked(mouseX, mouseY, mouseButton);
        if (mouseButton == 0) {
            Character c;
            if (mouseX >= 2 && mouseX < 14 && mouseY >= this.height - 14 && mouseY < this.height - 2) {
                this.showEmotePicker = !this.showEmotePicker;
                return;
            }
            if (this.showEmotePicker && (c = this.emotePicker.click(mouseX - 2, mouseY - (this.height - 16 - this.emotePicker.getHeight()))) != null) {
                this.editor.handleInput(0, c.charValue());
                if (!Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) && !Keyboard.isKeyDown(Keyboard.KEY_RSHIFT)) {
                    this.showEmotePicker = false;
                }
                return;
            }
        }
    }

    @Override
    public void setText(String text) {
        this.message = text;
    }

    @Override
    public String getText() {
        return this.message;
    }

    @Override
    public int maxLength() {
        return 256;
    }

    private String getMessage(int currentIndex) {
        return (String)this.mc.thePlayer.messageHistory.get(this.mc.thePlayer.messageHistory.size() - currentIndex);
    }
}

