/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import java.util.Arrays;
import net.minecraft.client.gui.ControllerGlyphRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.input.InputHandler;
import net.minecraft.client.input.InputType;
import net.minecraft.client.input.controller.ControllerInput;
import net.minecraft.client.input.controller.ControllerType;
import net.minecraft.client.input.controller.Joystick;
import net.minecraft.core.lang.I18n;
import org.lwjgl.opengl.GL11;

public class GuiControllerSetup
extends GuiScreen {
    private ControllerInput lastController = null;
    private GuiButton controllerButton;
    private ControllerGlyphRenderer glyphRenderer;

    public GuiControllerSetup(GuiScreen parentScreen) {
        super(parentScreen);
    }

    @Override
    public void init() {
        this.controllerButton = new GuiButton(0, 0, 0, "");
        this.controllerButton.xPosition = this.width / 2 - 100;
        this.controllerButton.yPosition = 16;
        this.controllerButton.width = 200;
        this.controllerButton.height = 20;
        this.controlList.add(this.controllerButton);
        this.controlList.add(new GuiButton(-1, this.width / 2 - 100, this.height - 40, I18n.getInstance().translateKey("gui.controller_setup.button.back")).setListener(e -> this.mc.displayGuiScreen(this.parentScreen)));
        this.glyphRenderer = new ControllerGlyphRenderer(this.mc);
        this.updateDisplay();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.mc.controllerInput != this.lastController) {
            this.updateDisplay();
            this.lastController = this.mc.controllerInput;
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float partialTick) {
        this.drawDefaultBackground();
        super.drawScreen(mouseX, mouseY, partialTick);
        ControllerInput controller = this.mc.controllerInput;
        if (controller != null) {
            boolean swapJoystickAndDPad = controller.getType().getCategory() == ControllerType.Category.XBOX || controller.getType().getCategory() == ControllerType.Category.NINTENDO;
            int y = this.height / 2 - 64;
            GL11.glDisable((int)2929);
            GL11.glDisable((int)2884);
            GL11.glDisable((int)3553);
            if (swapJoystickAndDPad) {
                this.drawJoystick(controller.joyLeft, this.width / 2 - 100 + 8, y + 32 + 4 + 8);
            } else {
                this.drawJoystick(controller.joyLeft, this.width / 2 - 48, y + 96);
            }
            this.drawJoystick(controller.joyRight, this.width / 2 - 48 + 64, y + 96);
            int x1 = this.width / 2;
            GL11.glEnable((int)3553);
            this.fontRenderer.drawCenteredString("(" + controller.getType().getPrintableName() + ")", this.width / 2, 40, 0xFFFFFF);
            int w = this.glyphRenderer.getButtonSizeU(controller, controller.buttonLeftTrigger);
            this.glyphRenderer.drawButton(controller, controller.buttonLeftTrigger, x1 - 65 - w, y, controller.buttonLeftTrigger.isPressed());
            this.glyphRenderer.drawButton(controller, controller.buttonRightTrigger, x1 + 65, y, controller.buttonRightTrigger.isPressed());
            w = this.glyphRenderer.getButtonSizeU(controller, controller.buttonBack);
            this.glyphRenderer.drawButton(controller, controller.buttonBack, x1 - 20 - w, y + 32, controller.buttonBack.isPressed());
            this.glyphRenderer.drawButton(controller, controller.buttonStart, x1 + 20, y + 32, controller.buttonStart.isPressed());
            w = this.glyphRenderer.getButtonSizeU(controller, controller.buttonLeftShoulder);
            this.glyphRenderer.drawButton(controller, controller.buttonLeftShoulder, x1 - 65 - w, y + 15, controller.buttonLeftShoulder.isPressed());
            this.glyphRenderer.drawButton(controller, controller.buttonRightShoulder, x1 + 65, y + 15, controller.buttonRightShoulder.isPressed());
            this.drawButtons(controller, this.width / 2 + 50, y + 32);
            if (swapJoystickAndDPad) {
                this.glyphRenderer.drawDPad(controller, x1 - 48 - 8, y + 96 - 8, controller.digitalPad.up.isPressed(), controller.digitalPad.right.isPressed(), controller.digitalPad.down.isPressed(), controller.digitalPad.left.isPressed());
            } else {
                this.glyphRenderer.drawDPad(controller, x1 - 48 - 8, y + 96 - 8, controller.digitalPad.up.isPressed(), controller.digitalPad.right.isPressed(), controller.digitalPad.down.isPressed(), controller.digitalPad.left.isPressed());
            }
        }
    }

    private void drawButtons(ControllerInput controller, int x, int y) {
        int w = 20;
        this.glyphRenderer.drawButton(controller, controller.buttonA, x + w * 1, y + w * 2, controller.buttonA.isPressed());
        this.glyphRenderer.drawButton(controller, controller.buttonB, x + w * 2, y + w * 1, controller.buttonB.isPressed());
        this.glyphRenderer.drawButton(controller, controller.buttonX, x + w * 0, y + w * 1, controller.buttonX.isPressed());
        this.glyphRenderer.drawButton(controller, controller.buttonY, x + w * 1, y + w * 0, controller.buttonY.isPressed());
    }

    private void drawDPad(ControllerInput controller, int x, int y) {
        GL11.glEnable((int)3553);
        this.mc.renderEngine.loadTexture("/assets/minecraft/textures/gui/controller/" + controller.getType().getAssetName() + ".png").bind();
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        GL11.glBegin((int)7);
        this.rectangle(x, y, 48.0, 48.0, 0, 64, 48, 48);
        if (controller.digitalPad.up.isPressed()) {
            this.rectangle(x + 18, y + 0, 12.0, 18.0, 66, 64, 12, 18);
        }
        if (controller.digitalPad.down.isPressed()) {
            this.rectangle(x + 18, y + 30, 12.0, 18.0, 66, 94, 12, 18);
        }
        if (controller.digitalPad.left.isPressed()) {
            this.rectangle(x + 0, y + 18, 18.0, 12.0, 48, 82, 18, 12);
        }
        if (controller.digitalPad.right.isPressed()) {
            this.rectangle(x + 30, y + 18, 18.0, 12.0, 78, 82, 18, 12);
        }
        GL11.glEnd();
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
    }

    private void drawJoystick(Joystick joystick, int x, int y) {
        GL11.glDisable((int)3553);
        GL11.glBegin((int)7);
        GL11.glColor3d((double)0.5, (double)0.5, (double)0.5);
        this.rectangle(x, y, 32.0, 32.0);
        GL11.glColor3d((double)0.0, (double)1.0, (double)0.0);
        if (joystick.getButton().isPressed()) {
            GL11.glColor3d((double)1.0, (double)0.0, (double)0.0);
        }
        this.rectangle((double)x + ((double)joystick.getX() * 0.5 + 0.5) * 32.0 - 1.0, (double)y + ((double)joystick.getY() * 0.5 + 0.5) * 32.0 - 1.0, 2.0, 2.0);
        GL11.glEnd();
        GL11.glEnable((int)3553);
    }

    private void rectangle(double x, double y, double w, double h) {
        GL11.glVertex2d((double)x, (double)y);
        GL11.glVertex2d((double)(x + w), (double)y);
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL11.glVertex2d((double)x, (double)(y + h));
    }

    private void rectangle(double x, double y, double w, double h, int u0, int v0, int uw, int vh) {
        double u1 = u0 + uw;
        double v1 = v0 + vh;
        GL11.glTexCoord2d((double)((double)u0 / 256.0), (double)((double)v0 / 256.0));
        GL11.glVertex2d((double)x, (double)y);
        GL11.glTexCoord2d((double)(u1 / 256.0), (double)((double)v0 / 256.0));
        GL11.glVertex2d((double)(x + w), (double)y);
        GL11.glTexCoord2d((double)(u1 / 256.0), (double)(v1 / 256.0));
        GL11.glVertex2d((double)(x + w), (double)(y + h));
        GL11.glTexCoord2d((double)((double)u0 / 256.0), (double)(v1 / 256.0));
        GL11.glVertex2d((double)x, (double)(y + h));
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        super.buttonPressed(button);
        if (button.id == 0) {
            int index;
            if (this.mc.controllerInput == null) {
                index = 0;
            } else {
                index = Arrays.asList(InputHandler.controllers).indexOf(this.mc.controllerInput);
                do {
                    if (++index < InputHandler.controllers.length) continue;
                    index = -1;
                    break;
                } while (InputHandler.controllers[index] == null);
            }
            if (index == -1) {
                this.mc.controllerInput = null;
                this.mc.setInputType(InputType.KEYBOARD);
            } else {
                this.mc.controllerInput = InputHandler.controllers[index];
                this.mc.setInputType(InputType.CONTROLLER);
            }
            this.updateDisplay();
            this.save();
        }
    }

    @Override
    public void onClosed() {
        if (this.mc.inputType == InputType.CONTROLLER) {
            this.mc.mouseInput.grabCursor();
        }
    }

    private void updateDisplay() {
        if (this.mc.controllerInput != null) {
            this.controllerButton.displayString = this.mc.controllerInput.getController().getName();
            if (this.controllerButton.displayString.startsWith("SDL GameController ")) {
                this.controllerButton.displayString = this.controllerButton.displayString.substring(19);
            }
        } else {
            this.controllerButton.displayString = I18n.getInstance().translateKey("gui.controller_setup.label.no_controller_selected");
        }
    }

    private void save() {
        this.mc.gameSettings.selectedController.value = this.mc.controllerInput != null ? this.mc.controllerInput.getGUID() : "";
        this.mc.gameSettings.saveOptions();
    }
}

