/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui;

import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.net.command.TextFormatting;
import net.minecraft.core.net.packet.SetItemNamePacket;
import net.minecraft.core.util.helper.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiEditLabel
extends GuiScreen {
    private static final String allowedCharacters = ChatAllowedCharacters.ALLOWED_CHARACTERS;
    protected String screenTitle = I18n.getInstance().translateKey("gui.edit_label.label.title");
    protected ItemStack item;
    protected String text;
    protected byte color;
    protected int xSize;
    protected int ySize;
    protected int slot;

    public GuiEditLabel(ItemStack item, int slot) {
        this.item = item;
        this.text = item.hasCustomName() ? item.getCustomName() : "";
        this.color = item.getDisplayColor();
        this.xSize = 176;
        this.ySize = 166;
        this.slot = slot;
    }

    @Override
    protected void buttonPressed(GuiButton button) {
        if (!button.enabled) {
            return;
        }
        if (button.id == 0) {
            this.item.setCustomName(this.text);
            this.mc.displayGuiScreen(null);
            if (this.mc.theWorld.isClientSide) {
                this.mc.getSendQueue().addToSendQueue(new SetItemNamePacket(this.slot, this.text));
            }
        }
    }

    @Override
    public void drawScreen(int mouseX, int mouseY, float f) {
        this.drawDefaultBackground();
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.mc.renderEngine.loadTexture("/assets/minecraft/textures/gui/scroll.png").bind();
        int widthBG = this.width / 2 - 56;
        int heightBG = 89;
        this.drawTexturedModalRect(widthBG, 89, 0, 0, 113, 34);
        this.drawStringCentered(this.fontRenderer, this.screenTitle, this.width / 2, 40, 0xFFFFFF);
        this.drawStringCentered(this.fontRenderer, TextFormatting.get(this.color) + "> " + this.text + " <", this.width / 2, 100, 0xFFFFFF);
        super.drawScreen(mouseX, mouseY, f);
    }

    @Override
    public void init() {
        this.controlList.clear();
        Keyboard.enableRepeatEvents(true);
        this.controlList.add(new GuiButton(0, this.width / 2 - 100, this.height / 4 + 120, I18n.getInstance().translateKey("gui.edit_label.button.done")));
    }

    @Override
    public void keyTyped(char c, int i, int mouseX, int mouseY) {
        if (i == Keyboard.KEY_BACK && this.text.length() > 0) {
            this.text = this.text.substring(0, this.text.length() - 1);
        }
        if (allowedCharacters.indexOf(c) >= 0 && this.text.length() < 15) {
            this.text = this.text + c;
        }
        if (i == Keyboard.KEY_RETURN || i == Keyboard.KEY_ESCAPE) {
            this.buttonPressed((GuiButton)this.controlList.get(0));
        }
    }

    @Override
    public void onClosed() {
        Keyboard.enableRepeatEvents(false);
    }
}

