/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.achievements.data;

import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.achievements.GuiAchievements;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.texture.stitcher.IconCoordinate;
import net.minecraft.core.achievement.Achievement;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.block.Block;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AchievementPage {
    @NotNull
    public abstract String getName();

    @NotNull
    public abstract String getDescription();

    public abstract void addAchievement(@NotNull Achievement var1);

    @NotNull
    public abstract Achievement onOpenAchievement();

    @Nullable
    public abstract IconCoordinate getBackgroundTile(GuiAchievements var1, int var2, Random var3, int var4, int var5);

    public abstract void postProcessBackground(GuiAchievements var1, Random var2, GuiAchievements.BGLayer var3, int var4, int var5);

    @NotNull
    public abstract ItemStack getIcon();

    @NotNull
    public abstract List<Achievement> getAchievements();

    public abstract double getCompletionFraction(StatsCounter var1);

    public abstract int backgroundLayers();

    public abstract int backgroundColor();

    public abstract boolean hasAchievement(Achievement var1);

    public abstract IconCoordinate getAchievementIcon(Achievement var1);

    public abstract int lineColorLocked(boolean var1);

    public abstract int lineColorUnlocked(boolean var1);

    public abstract int lineColorCanUnlock(boolean var1);

    public static IconCoordinate getTextureFromBlock(Block block) {
        return ((BlockModel)BlockModelDispatcher.getInstance().getDispatch(block)).getBlockTextureFromSideAndMetadata(Side.TOP, 0);
    }
}

