/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook;

import java.util.Stack;

public class PageNavigationStack {
    private final int maxSize;
    private final Stack<Integer> stack = new Stack();
    private int stackPointer = 0;

    public PageNavigationStack(int maxSize) {
        this.maxSize = maxSize;
    }

    private void incSP() {
        ++this.stackPointer;
        if (this.stackPointer > this.stack.size() - 1) {
            this.stackPointer = this.stack.size() - 1;
        }
    }

    private void decSP() {
        --this.stackPointer;
        if (this.stackPointer < 0) {
            this.stackPointer = 0;
        }
    }

    public void pushPage(int page) {
        if (this.stackPointer < this.stack.size() - 1) {
            this.stack.subList(this.stackPointer + 1, this.stack.size()).clear();
        }
        if (this.stack.size() >= this.maxSize) {
            this.stack.remove(0);
        }
        this.stack.push(page);
        this.incSP();
    }

    public int getCurrentPage() {
        if (this.stack.isEmpty()) {
            this.stack.push(0);
        }
        return (Integer)this.stack.get(this.stackPointer);
    }

    public void goBack() {
        this.decSP();
        System.out.println(this.stackPointer + "/" + (this.stack.size() - 1));
    }

    public void goForward() {
        this.incSP();
        System.out.println(this.stackPointer + "/" + (this.stack.size() - 1));
    }
}

