/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.guidebook.trommeling;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.client.gui.GuiTooltip;
import net.minecraft.client.gui.guidebook.GuiGuidebook;
import net.minecraft.client.gui.guidebook.GuidebookPage;
import net.minecraft.client.gui.guidebook.GuidebookSection;
import net.minecraft.client.gui.guidebook.GuidebookSections;
import net.minecraft.client.gui.guidebook.PageManager;
import net.minecraft.client.gui.guidebook.RecipePage;
import net.minecraft.client.gui.guidebook.search.SearchPage;
import net.minecraft.client.render.FontRenderer;
import net.minecraft.client.render.RenderEngine;
import net.minecraft.core.WeightedRandomBag;
import net.minecraft.core.WeightedRandomLootObject;
import net.minecraft.core.achievement.Achievements;
import net.minecraft.core.data.registry.recipe.RecipeSymbol;
import net.minecraft.core.data.registry.recipe.SearchQuery;
import net.minecraft.core.data.registry.recipe.entry.RecipeEntryTrommel;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.GuidebookSlot;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class TrommelPage
extends RecipePage<RecipeEntryTrommel> {
    public static final int RECIPES_PER_PAGE = 3;
    public List<GuidebookSlot> slots;
    public Map<RecipeEntryTrommel, List<GuidebookSlot>> map;
    private final GuiTooltip guiTooltip;
    private final GuiRenderItem guiRenderItem;
    private static final Minecraft mc = Minecraft.getMinecraft(GuidebookPage.class);
    private static Player player;
    private static long ticks;
    private static long ticks2;

    public TrommelPage(GuidebookSection section, List<RecipeEntryTrommel> recipes) {
        super(section);
        this.recipes = recipes;
        this.slots = new ArrayList<GuidebookSlot>();
        this.map = new HashMap<RecipeEntryTrommel, List<GuidebookSlot>>();
        player = TrommelPage.mc.thePlayer;
        player.addStat(Achievements.OPEN_GUIDEBOOK, 1);
        this.guiTooltip = new GuiTooltip(mc);
        this.guiRenderItem = new GuiRenderItem(mc);
        int recipeAmount = 0;
        int yOffset = 8;
        for (RecipeEntryTrommel recipe : recipes) {
            ArrayList<GuidebookSlot> recipeSlots = new ArrayList<GuidebookSlot>();
            int slotsAmount = 10;
            for (int i = 0; i < slotsAmount - 1; ++i) {
                if (((WeightedRandomBag)recipe.getOutput()).getEntries().size() > i) {
                    ItemStack stack = ((WeightedRandomLootObject)((WeightedRandomBag)recipe.getOutput()).getEntries().get(i)).getItemStack();
                    recipeSlots.add(new GuidebookSlot(i, 81 + 20 * (i % 3), 1 + 20 * (i / 3 + recipeAmount * 3) + yOffset, new RecipeSymbol(stack), false, recipe).setAsOutput());
                    continue;
                }
                recipeSlots.add(new GuidebookSlot(i, 81 + 20 * (i % 3), 1 + 20 * (i / 3 + recipeAmount * 3) + yOffset, null, false, recipe).setAsOutput());
            }
            int centerY = (((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 1))).y + ((GuidebookSlot)recipeSlots.get((int)(recipeSlots.size() - 8))).y) / 2;
            recipeSlots.add(new GuidebookSlot(slotsAmount - 1, 19, centerY, (RecipeSymbol)recipe.getInput(), false, recipe));
            this.map.put(recipe, recipeSlots);
            this.slots.addAll(recipeSlots);
            yOffset += 4;
            ++recipeAmount;
        }
    }

    @Override
    protected void renderForeground(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        if (this.recipes.isEmpty()) {
            this.drawStringCenteredNoShadow(fr, "No recipes found :(", x + 79, y + 110, -8355712);
        }
        GuidebookSlot mouseOverSlot = null;
        ++ticks;
        if (++ticks2 > 200L) {
            ticks2 = 0L;
            for (GuidebookSlot slot : this.slots) {
                RecipeSymbol input;
                if (!(slot.recipe instanceof RecipeEntryTrommel) || (input = (RecipeSymbol)slot.recipe.getInput()).matches(slot.getItem()) || slot.recipeAmount <= 8) continue;
                int recipeIndexMax = Math.round((float)slot.recipeAmount / 9.0f);
                slot.recipeIndex = slot.recipeIndex >= recipeIndexMax ? 0 : ++slot.recipeIndex;
                WeightedRandomBag loot = (WeightedRandomBag)slot.recipe.getOutput();
                int index = slot.index + 9 * slot.recipeIndex;
                if (index > slot.recipeAmount) {
                    slot.item = null;
                    continue;
                }
                slot.item = ((WeightedRandomLootObject)loot.getEntries().get(index)).getItemStack();
            }
        }
        for (GuidebookSlot slot : this.slots) {
            if (ticks > 150L) {
                slot.showRandomItem();
                if (this.slots.get(this.slots.size() - 1) == slot) {
                    ticks = 0L;
                }
            }
            this.drawSlot(x + slot.x - 1, y + slot.y - 1, -1);
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            this.guiRenderItem.render(slot.getItem(), x + slot.x, y + slot.y, mouseOverSlot == slot, slot);
        }
    }

    public boolean getIsMouseOverSlot(Slot slot, int x, int y, int mouseX, int mouseY) {
        return mouseX >= x + slot.x - 1 && mouseX < x + slot.x + 16 + 1 && mouseY >= y + slot.y - 1 && mouseY < y + slot.y + 16 + 1;
    }

    @Override
    public void keyTyped(char c, int key, int x, int y, int mouseX, int mouseY) {
        super.keyTyped(c, key, x, y, mouseX, mouseY);
        if (TrommelPage.mc.gameSettings.keyShowRecipe.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "r:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuiGuidebook.getPageManager().updatePages();
                GuiGuidebook.getPageManager().setCurrentPage(GuiGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        } else if (TrommelPage.mc.gameSettings.keyShowUsage.isKeyboardKey(key)) {
            GuidebookSlot hoveringSlot = null;
            for (GuidebookSlot slot : this.slots) {
                if (!this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) continue;
                hoveringSlot = slot;
            }
            if (hoveringSlot != null && hoveringSlot.hasItem()) {
                String query = "u:" + hoveringSlot.getItem().getDisplayName() + "!";
                PageManager.searchQuery = SearchQuery.resolve(query);
                SearchPage.searchField.setText(query);
                GuiGuidebook.getPageManager().updatePages();
                GuiGuidebook.getPageManager().setCurrentPage(GuiGuidebook.getPageManager().getSectionIndex(GuidebookSections.CRAFTING), true);
            }
        }
    }

    @Override
    public void render(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.render(re, fr, x, y, mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderBackground(RenderEngine re, int x, int y) {
        super.renderBackground(re, x, y);
        re.bindTexture(re.loadTexture("/assets/minecraft/textures/gui/container/guidebook/guidebook.png"));
        for (int i = 1; i <= this.recipes.size(); ++i) {
            RecipeEntryTrommel recipe = (RecipeEntryTrommel)this.recipes.get(i - 1);
            List<GuidebookSlot> list = this.map.get(recipe);
            this.drawTexturedModalRect(x + list.get((int)(list.size() - 1)).x + 25, y + list.get((int)(list.size() - 1)).y, 234, 0, 22, 15);
        }
    }

    @Override
    protected void renderOverlay(RenderEngine re, FontRenderer fr, int x, int y, int mouseX, int mouseY, float partialTicks) {
        super.renderOverlay(re, fr, x, y, mouseX, mouseY, partialTicks);
        GuidebookSlot mouseOverSlot = null;
        for (GuidebookSlot slot : this.slots) {
            boolean showDescription;
            if (this.getIsMouseOverSlot(slot, x, y, mouseX, mouseY)) {
                mouseOverSlot = slot;
            }
            GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (mouseOverSlot == null || !mouseOverSlot.hasItem()) continue;
            boolean bl = showDescription = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL) || (Boolean)TrommelPage.mc.gameSettings.alwaysShowDescriptions.value != false;
            String str = this.guiTooltip.getTooltipText(mouseOverSlot.getItem(), showDescription, mouseOverSlot);
            if (str.isEmpty()) continue;
            this.guiTooltip.render(str, mouseX, mouseY, 8, -8);
        }
    }

    static {
        ticks = 0L;
        ticks2 = 0L;
    }
}

