/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.block;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.block.BlockEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListSelectorButton;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.entity.MobSpawnerBlockEntity;
import net.minecraft.core.entity.EntityDispatcher;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.DisplayChunk;

public class MobSpawnerEntry
extends BlockEntry {
    public MobSpawnerEntry() {
        super(Blocks.MOBSPAWNER);
    }

    @Override
    public void onTick(World world, int meta) {
        MobSpawnerBlockEntity spawner = (MobSpawnerBlockEntity)DisplayChunk.displayBlockEntity;
        spawner.yaw2 = spawner.yaw;
        double xPos = (double)spawner.x + (double)spawner.worldObj.rand.nextFloat();
        double yPos = (double)spawner.y + (double)spawner.worldObj.rand.nextFloat();
        double zPos = (double)spawner.z + (double)spawner.worldObj.rand.nextFloat();
        spawner.worldObj.spawnParticle("smoke", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        spawner.worldObj.spawnParticle("flame", xPos, yPos, zPos, 0.0, 0.0, 0.0, 0);
        spawner.yaw += (double)(1000.0f / ((float)spawner.delay + 200.0f));
        while (spawner.yaw > 360.0) {
            spawner.yaw -= 360.0;
            spawner.yaw2 -= 360.0;
        }
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, World world, int meta) {
        ArrayList<String> ids = new ArrayList<String>(EntityDispatcher.keyToClassMap.keySet());
        ids.remove("mob");
        final GuiListSelectorButton<String> dispatcherIds = new GuiListSelectorButton<String>(-1, -120, 0, 120, 20, I18n.getInstance().translateKey("model.category.block.spawner.button.id"), ids, "Pig"){

            @Override
            public String getNameFromElement(String element) {
                return element;
            }
        };
        dispatcherIds.setOnValueChanged(() -> ((MobSpawnerBlockEntity)DisplayChunk.displayBlockEntity).setMobId((String)dispatcherIds.getCurrentElement()));
        return new ArrayList<GuiButton>(){
            {
                this.add(dispatcherIds);
            }
        };
    }

    @Override
    public void onClose(World world, int meta) {
    }

    @Override
    public void onOpen(World world, int meta) {
    }
}

