/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.gui.modelviewer.categories.entries.entity;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.modelviewer.categories.entries.entity.EntityEntry;
import net.minecraft.client.gui.modelviewer.elements.GuiListenerSlider;
import net.minecraft.core.entity.animal.SheepMob;
import net.minecraft.core.lang.I18n;
import net.minecraft.core.util.helper.DyeColor;
import net.minecraft.core.world.World;

public class EntitySheepEntry
extends EntityEntry<SheepMob> {
    @Override
    public void onTick(SheepMob entity) {
    }

    @Override
    public List<GuiButton> getEntryButtons(Minecraft mc, GuiScreen parentScreen, SheepMob sheep) {
        ArrayList<GuiButton> buttonList = new ArrayList<GuiButton>();
        GuiListenerSlider slider = new GuiListenerSlider(-1, -120, 0, 120, 20, I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", "White"), 0.0f);
        slider.setOnValueChanged(() -> {
            sheep.setFleeceColor(DyeColor.colorFromBlockMeta((int)(slider.sliderValue * 15.0f)));
            String color = sheep.getFleeceColor().colorID;
            String c = String.valueOf(color.charAt(0));
            color = c.toUpperCase() + color.substring(1);
            slider.displayString = I18n.getInstance().translateKeyAndFormat("model.category.entity.sheep.slider.color", color);
        });
        buttonList.add(slider);
        return buttonList;
    }

    @Override
    public SheepMob getEntityInstance(Minecraft mc, World world) {
        SheepMob sheep = new SheepMob(world);
        sheep.setFleeceColor(DyeColor.WHITE);
        return sheep;
    }

    @Override
    public void onOpen() {
    }

    @Override
    public void onClose() {
    }
}

