/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input;

import java.util.ArrayList;
import java.util.List;
import net.java.games.input.Component;
import net.java.games.input.Controller;
import net.minecraft.client.Minecraft;
import net.minecraft.client.input.InputHandler;
import org.lwjgl.input.Mouse;

public class MouseInput {
    public final Minecraft minecraft;
    private List<MouseDevice> mouses;
    public double deltaX;
    public double deltaY;

    public MouseInput(Minecraft minecraft) {
        this.minecraft = minecraft;
    }

    public void grabCursor() {
        Mouse.setGrabbed(true);
        Mouse.setCursorPosition(this.minecraft.resolution.width / 2, this.minecraft.resolution.height / 2);
    }

    public void releaseCursor() {
        Mouse.setGrabbed(false);
        Mouse.setCursorPosition(this.minecraft.resolution.width / 2, this.minecraft.resolution.height / 2);
    }

    public void update() {
        if (((Boolean)this.minecraft.gameSettings.rawMouseInput.value).booleanValue() && this.mouses != null && this.mouses.size() > 0) {
            this.deltaX = 0.0;
            this.deltaY = 0.0;
            for (int i = 0; i < this.mouses.size(); ++i) {
                MouseDevice mouse = this.mouses.get(i);
                mouse.device.poll();
                this.deltaX += (double)mouse.x.getPollData() * 0.5;
                this.deltaY += (double)mouse.y.getPollData() * -0.5;
            }
        } else {
            this.deltaX = Mouse.getDX();
            this.deltaY = Mouse.getDY();
        }
    }

    public void addMouse(Controller controller) {
        if (this.mouses == null) {
            this.mouses = new ArrayList<MouseDevice>();
        }
        this.mouses.add(new MouseDevice(controller));
    }

    public static class MouseDevice {
        private Controller device;
        private Component x;
        private Component y;

        public MouseDevice(Controller device) {
            this.device = device;
            this.x = InputHandler.getComponent(device, "x");
            this.y = InputHandler.getComponent(device, "y");
        }
    }
}

