/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.input.controller;

import java.util.Arrays;
import java.util.List;
import net.minecraft.client.input.glfw.GlfwGamepad;

public enum ControllerType {
    UNKNOWN(Category.XBOX, "xbox", "UNKNOWN"),
    XBOX360(Category.XBOX, "xbox", "XBOX 360"),
    XBOXONE(Category.XBOX, "xbox", "XBOX ONE"),
    PS3(Category.PLAYSTATION, "playstation", "PLAYSTATION 3"),
    PS4(Category.PLAYSTATION, "playstation", "PLAYSTATION 4"),
    PS5(Category.PLAYSTATION, "playstation", "PLAYSTATION 5"),
    NINTENDO_SWITCH_PRO(Category.NINTENDO, "nintendo", "NINTENDO SWITCH PRO");

    private final Category category;
    private final String assetName;
    private final String printableName;

    private ControllerType(Category category, String assetName, String printableName) {
        this.category = category;
        this.assetName = assetName;
        this.printableName = printableName;
    }

    public static ControllerType fromController(GlfwGamepad controller) {
        List<String> name = Arrays.asList(controller.getName().toLowerCase().split(" "));
        if (name.contains("xbox") || name.contains("xinput")) {
            if (name.contains("one")) {
                return XBOXONE;
            }
            return XBOX360;
        }
        if (name.contains("playstation") && name.contains("3") || name.contains("ps3")) {
            return PS3;
        }
        if (name.contains("playstation") && name.contains("4") || name.contains("ps4")) {
            return PS4;
        }
        if (name.contains("playstation") && name.contains("5") || name.contains("ps5")) {
            return PS5;
        }
        if (name.contains("nintendo") && name.contains("switch") && name.contains("pro")) {
            return NINTENDO_SWITCH_PRO;
        }
        return UNKNOWN;
    }

    public Category getCategory() {
        return this.category;
    }

    public String getAssetName() {
        return this.assetName;
    }

    public String getPrintableName() {
        return this.printableName;
    }

    public static enum Category {
        XBOX,
        PLAYSTATION,
        NINTENDO;

    }
}

