/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.client.render.BlockEntityRenderDispatcher;
import net.minecraft.client.render.LightmapHelper;
import net.minecraft.client.render.RenderBlocks;
import net.minecraft.client.render.block.model.BlockModel;
import net.minecraft.client.render.block.model.BlockModelDispatcher;
import net.minecraft.client.render.camera.ICamera;
import net.minecraft.client.render.culling.CameraFrustum;
import net.minecraft.client.render.entity.ItemEntityRenderer;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.util.helper.MathHelper;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.world.World;
import net.minecraft.core.world.chunk.Chunk;
import net.minecraft.core.world.chunk.ChunkCache;
import org.lwjgl.opengl.GL11;

public class ChunkRenderer {
    public static final int MAX_RENDER_PASSES = 2;
    public World world;
    private final int lists;
    private static final Tessellator tessellator;
    public static int updates;
    public int x;
    public int y;
    public int z;
    public int xs;
    public int ys;
    public int zs;
    public int xRender;
    public int yRender;
    public int zRender;
    public int xRenderOffs;
    public int yRenderOffs;
    public int zRenderOffs;
    public boolean visible = false;
    public boolean[] empty = new boolean[2];
    public int xm;
    public int ym;
    public int zm;
    public float radius;
    public boolean dirty;
    public AABB bb;
    public int id;
    public boolean occlusionVisible = true;
    public boolean occlusionQuerying;
    public int occlusionId;
    public boolean skyLit;
    private boolean compiled = false;
    public List<BlockEntity> renderableBlockEntities = new ArrayList<BlockEntity>();
    private final List<BlockEntity> globalRenderableBlockEntities;

    public ChunkRenderer(World world, List<BlockEntity> globalRenderableTileEntities, int x, int y, int z, int size, int lists) {
        this.world = world;
        this.globalRenderableBlockEntities = globalRenderableTileEntities;
        this.ys = this.zs = size;
        this.xs = this.zs;
        this.radius = MathHelper.sqrt_float(this.xs * this.xs + this.ys * this.ys + this.zs * this.zs) / 2.0f;
        this.lists = lists;
        this.x = -999;
        this.setPos(x, y, z);
        this.dirty = false;
    }

    public void setPos(int x, int y, int z) {
        if (x != this.x || y != this.y || z != this.z) {
            this.reset();
            this.x = x;
            this.y = y;
            this.z = z;
            this.xm = x + this.xs / 2;
            this.ym = y + this.ys / 2;
            this.zm = z + this.zs / 2;
            this.xRenderOffs = x & 0x3FF;
            this.yRenderOffs = y;
            this.zRenderOffs = z & 0x3FF;
            this.xRender = x - this.xRenderOffs;
            this.yRender = y - this.yRenderOffs;
            this.zRender = z - this.zRenderOffs;
            float f = 6.0f;
            this.bb = AABB.getPermanentBB((float)x - f, (float)y - f, (float)z - f, (float)(x + this.xs) + f, (float)(y + this.ys) + f, (float)(z + this.zs) + f);
            GL11.glNewList((int)(this.lists + 2), (int)4864);
            ItemEntityRenderer.renderFlatAABB(AABB.getTemporaryBB((float)this.xRenderOffs - f, (float)this.yRenderOffs - f, (float)this.zRenderOffs - f, (float)(this.xRenderOffs + this.xs) + f, (float)(this.yRenderOffs + this.ys) + f, (float)(this.zRenderOffs + this.zs) + f));
            GL11.glEndList();
            this.setDirty();
        }
    }

    private void translateToPos() {
        GL11.glTranslatef((float)this.xRenderOffs, (float)this.yRenderOffs, (float)this.zRenderOffs);
    }

    public void rebuild() {
        if (!this.dirty) {
            return;
        }
        ++updates;
        int minX = this.x;
        int minY = this.y;
        int minZ = this.z;
        int maxX = this.x + this.xs;
        int maxY = this.y + this.ys;
        int maxZ = this.z + this.zs;
        for (int i = 0; i < 2; ++i) {
            this.empty[i] = true;
        }
        Chunk.isLit = false;
        HashSet<BlockEntity> lastSpecialTileEntities = new HashSet<BlockEntity>(this.renderableBlockEntities);
        this.renderableBlockEntities.clear();
        boolean cacheRadius = true;
        ChunkCache chunkcache = new ChunkCache(this.world, minX - 1, minY - 1, minZ - 1, maxX + 1, maxY + 1, maxZ + 1);
        RenderBlocks renderblocks = new RenderBlocks(chunkcache);
        BlockModel.setRenderBlocks(renderblocks);
        for (int renderPass = 0; renderPass < 2; ++renderPass) {
            boolean needsMoreRenderPasses = false;
            boolean hasRenderedBlock = false;
            boolean hasStartedDrawing = false;
            for (int y = minY; y < maxY; ++y) {
                for (int z = minZ; z < maxZ; ++z) {
                    for (int x = minX; x < maxX; ++x) {
                        Block block;
                        int blockRenderPass;
                        BlockEntity tileentity;
                        int blockId = chunkcache.getBlockId(x, y, z);
                        if (blockId <= 0) continue;
                        if (!hasStartedDrawing) {
                            hasStartedDrawing = true;
                            GL11.glNewList((int)(this.lists + renderPass), (int)4864);
                            GL11.glPushMatrix();
                            this.translateToPos();
                            float scale = 1.000001f;
                            GL11.glTranslatef((float)((float)(-this.zs) / 2.0f), (float)((float)(-this.ys) / 2.0f), (float)((float)(-this.zs) / 2.0f));
                            GL11.glScalef((float)1.000001f, (float)1.000001f, (float)1.000001f);
                            GL11.glTranslatef((float)((float)this.zs / 2.0f), (float)((float)this.ys / 2.0f), (float)((float)this.zs / 2.0f));
                            tessellator.startDrawingQuads();
                            tessellator.setTranslation(-this.x, -this.y, -this.z);
                            if (LightmapHelper.isLightmapEnabled()) {
                                tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 15));
                            }
                        }
                        if (renderPass == 0 && Block.isEntityTile[blockId] && BlockEntityRenderDispatcher.instance.hasRenderer(tileentity = chunkcache.getBlockEntity(x, y, z))) {
                            this.renderableBlockEntities.add(tileentity);
                        }
                        if ((blockRenderPass = (block = Block.blocksList[blockId]).getRenderLayer()) != renderPass) {
                            needsMoreRenderPasses = true;
                            continue;
                        }
                        if (LightmapHelper.isLightmapEnabled()) {
                            tessellator.setLightmapCoord(LightmapHelper.getLightmapCoord(15, 0));
                        }
                        BlockModel model = (BlockModel)BlockModelDispatcher.getInstance().getDispatch(block);
                        hasRenderedBlock |= model.render(tessellator, x, y, z);
                        if (!model.hasOverbright()) continue;
                        renderblocks.overbright = true;
                        hasRenderedBlock |= model.render(tessellator, x, y, z);
                        renderblocks.overbright = false;
                    }
                }
            }
            if (hasStartedDrawing) {
                tessellator.draw();
                GL11.glPopMatrix();
                GL11.glEndList();
                tessellator.setTranslation(0.0, 0.0, 0.0);
            } else {
                hasRenderedBlock = false;
            }
            if (hasRenderedBlock) {
                this.empty[renderPass] = false;
            }
            if (!needsMoreRenderPasses) break;
        }
        HashSet<BlockEntity> newSpecialTileEntities = new HashSet<BlockEntity>(this.renderableBlockEntities);
        newSpecialTileEntities.removeAll(lastSpecialTileEntities);
        this.globalRenderableBlockEntities.addAll(newSpecialTileEntities);
        this.renderableBlockEntities.forEach(lastSpecialTileEntities::remove);
        this.globalRenderableBlockEntities.removeAll(lastSpecialTileEntities);
        this.skyLit = Chunk.isLit;
        this.compiled = true;
    }

    public float distanceToEntitySquared(Entity entity) {
        float dx = (float)(entity.x - (double)this.xm);
        float dy = (float)(entity.y - (double)this.ym);
        float dz = (float)(entity.z - (double)this.zm);
        return dx * dx + dy * dy + dz * dz;
    }

    public float distanceToCameraSquared(ICamera camera) {
        float dx = (float)(camera.getX(1.0f) - (double)this.xm);
        float dy = (float)(camera.getY(1.0f) - (double)this.ym);
        float dz = (float)(camera.getZ(1.0f) - (double)this.zm);
        return dx * dx + dy * dy + dz * dz;
    }

    public void reset() {
        for (int i = 0; i < 2; ++i) {
            this.empty[i] = true;
        }
        this.visible = false;
        this.compiled = false;
    }

    public void delete() {
        this.reset();
        this.world = null;
    }

    public int getList(int layer) {
        if (!this.visible) {
            return -1;
        }
        if (!this.empty[layer]) {
            return this.lists + layer;
        }
        return -1;
    }

    public void cull(CameraFrustum frustum, float partialTick) {
        this.visible = frustum.isVisible(this.bb, partialTick);
    }

    public void renderBB() {
        GL11.glCallList((int)(this.lists + 2));
    }

    public boolean isEmpty() {
        if (!this.compiled) {
            return false;
        }
        return this.empty[0] && this.empty[1];
    }

    public void setDirty() {
        this.dirty = true;
    }

    static {
        updates = 0;
        tessellator = Tessellator.instance;
    }
}

