/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.block.model;

import net.minecraft.client.render.block.model.StandardBlockModel;
import net.minecraft.client.render.tessellator.Tessellator;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.FireflyLanternBlock;
import net.minecraft.core.block.RopeBlock;
import net.minecraft.core.block.tag.BlockTags;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.WorldSource;

public class RopeBlockModel<T extends RopeBlock>
extends StandardBlockModel<T> {
    public RopeBlockModel(Block block) {
        super(block);
    }

    @Override
    public boolean render(Tessellator tessellator, int x, int y, int z) {
        WorldSource world = RopeBlockModel.renderBlocks.blockAccess;
        boolean hasFloor = world.getBlock(x, y - 1, z) != null && world.getBlock(x, y - 1, z).canPlaceOnSurface();
        boolean hasBlockNegX = this.canConnect(world, x, y, z, Side.WEST);
        boolean hasBlockPosX = this.canConnect(world, x, y, z, Side.EAST);
        boolean hasBlockNegY = this.canConnect(world, x, y, z, Side.BOTTOM) || hasFloor;
        boolean hasBlockPosY = this.canConnect(world, x, y, z, Side.TOP);
        boolean hasBlockNegZ = this.canConnect(world, x, y, z, Side.NORTH);
        boolean hasBlockPosZ = this.canConnect(world, x, y, z, Side.SOUTH);
        boolean drawKnot = !(hasBlockNegX && hasBlockPosX && !hasBlockNegY && !hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && hasBlockNegY && hasBlockPosY && !hasBlockNegZ && !hasBlockPosZ || !hasBlockNegX && !hasBlockPosX && !hasBlockNegY && !hasBlockPosY && hasBlockNegZ && hasBlockPosZ);
        ((RopeBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        float ropeThickness = 0.0625f;
        float knotThickness = 0.125f;
        float pileWidth = 0.1875f;
        if (drawKnot) {
            ((RopeBlock)this.block).setBlockBounds(0.375, 0.375, 0.375, 0.625, 0.625, 0.625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockPosY) {
            ((RopeBlock)this.block).setBlockBounds(0.4375, 0.5, 0.4375, 0.5625, 1.0, 0.5625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockNegY) {
            ((RopeBlock)this.block).setBlockBounds(0.4375, 0.0, 0.4375, 0.5625, 0.5, 0.5625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockPosX) {
            ((RopeBlock)this.block).setBlockBounds(0.5, 0.4375, 0.4375, 1.0, 0.5625, 0.5625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockNegX) {
            ((RopeBlock)this.block).setBlockBounds(0.0, 0.4375, 0.4375, 0.5, 0.5625, 0.5625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockPosZ) {
            ((RopeBlock)this.block).setBlockBounds(0.4375, 0.4375, 0.5, 0.5625, 0.5625, 1.0);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasBlockNegZ) {
            ((RopeBlock)this.block).setBlockBounds(0.4375, 0.4375, 0.0, 0.5625, 0.5625, 0.5);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        if (hasFloor) {
            ((RopeBlock)this.block).setBlockBounds(0.3125, 0.0, 0.3125, 0.6875, 0.125, 0.6875);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
            ((RopeBlock)this.block).setBlockBounds(0.375, 0.0, 0.375, 0.625, 0.1875, 0.625);
            this.renderStandardBlock(tessellator, this.block, x, y, z);
        }
        ((RopeBlock)this.block).setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        return true;
    }

    private boolean canConnect(WorldSource worldSource, int x, int y, int z, Side side) {
        int blockX = x + side.getOffsetX();
        int blockY = y + side.getOffsetY();
        int blockZ = z + side.getOffsetZ();
        Block _block = worldSource.getBlock(blockX, blockY, blockZ);
        if (side == Side.BOTTOM ? _block instanceof FireflyLanternBlock && (worldSource.getBlockMetadata(blockX, blockY, blockZ) & 1) != 0 : side == Side.TOP && (worldSource.isBlockOpaqueCube(blockX, blockY, blockZ) || BlockTags.CAN_HANG_OFF.appliesTo(_block))) {
            return true;
        }
        if ((worldSource.getBlockMetadata(x, y, z) & 0x80) != 0 && worldSource.isBlockOpaqueCube(blockX, blockY, blockZ)) {
            return true;
        }
        return _block == this.block;
    }
}

