/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.model;

import net.minecraft.client.render.model.BaseModel;
import net.minecraft.client.render.model.Cube;
import net.minecraft.core.util.helper.MathHelper;

public class CreeperModel
extends BaseModel {
    public Cube head;
    public Cube hair;
    public Cube body;
    public Cube leg1;
    public Cube leg2;
    public Cube leg3;
    public Cube leg4;

    public CreeperModel() {
        this(0.0f);
    }

    public CreeperModel(float expansion) {
        int yOff = 4;
        this.head = new Cube(0, 0);
        this.head.addBox(-4.0f, -6.0f, -4.0f, 8, 8, 8, expansion);
        this.head.setRotationPoint(0.0f, yOff, 0.0f);
        this.hair = new Cube(32, 0);
        this.hair.addBox(-4.0f, -6.0f, -4.0f, 8, 8, 8, expansion + 0.5f);
        this.hair.setRotationPoint(0.0f, yOff, 0.0f);
        this.body = new Cube(16, 16);
        this.body.addBox(-4.0f, 2.0f, -2.0f, 8, 12, 4, expansion);
        this.body.setRotationPoint(0.0f, yOff, 0.0f);
        this.leg1 = new Cube(0, 16);
        this.leg1.addBox(-2.0f, 2.0f, -2.0f, 4, 6, 4, expansion);
        this.leg1.setRotationPoint(-2.0f, 12 + yOff, 4.0f);
        this.leg2 = new Cube(0, 16);
        this.leg2.addBox(-2.0f, 2.0f, -2.0f, 4, 6, 4, expansion);
        this.leg2.setRotationPoint(2.0f, 12 + yOff, 4.0f);
        this.leg3 = new Cube(0, 16);
        this.leg3.addBox(-2.0f, 2.0f, -2.0f, 4, 6, 4, expansion);
        this.leg3.setRotationPoint(-2.0f, 12 + yOff, -4.0f);
        this.leg4 = new Cube(0, 16);
        this.leg4.addBox(-2.0f, 2.0f, -2.0f, 4, 6, 4, expansion);
        this.leg4.setRotationPoint(2.0f, 12 + yOff, -4.0f);
    }

    @Override
    public void render(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.setupAnimation(limbSwing, limbYaw, limbPitch, headYaw, headPitch, scale);
        this.head.render(scale);
        this.body.render(scale);
        this.leg1.render(scale);
        this.leg2.render(scale);
        this.leg3.render(scale);
        this.leg4.render(scale);
    }

    @Override
    public void setupAnimation(float limbSwing, float limbYaw, float limbPitch, float headYaw, float headPitch, float scale) {
        this.head.yRot = headYaw / 57.29578f;
        this.head.xRot = headPitch / 57.29578f;
        this.leg1.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
        this.leg2.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        this.leg3.xRot = MathHelper.cos(limbSwing * 0.6662f + (float)Math.PI) * 1.4f * limbYaw;
        this.leg4.xRot = MathHelper.cos(limbSwing * 0.6662f) * 1.4f * limbYaw;
    }
}

