/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.tessellator;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import net.minecraft.client.render.tessellator.TessellatorBase;
import net.minecraft.core.util.helper.MathHelper;
import org.lwjgl.opengl.GL13;

public class TessellatorStandard
extends TessellatorBase {
    private int drawMode;
    private boolean drawing;
    private ByteBuffer buffer;
    private boolean hasColor;
    private boolean hasTexture;
    private boolean hasLightmap;
    private boolean hasNormal;
    private int vertexCount = 0;
    private int color;
    private int lightmapCoord;
    private double textureU;
    private double textureV;
    private byte normalX;
    private byte normalY;
    private byte normalZ;
    private double offsetX;
    private double offsetY;
    private double offsetZ;
    private boolean lockedColor = false;

    public TessellatorStandard(int bufferSize) {
        this.buffer = ByteBuffer.allocateDirect(bufferSize).order(ByteOrder.nativeOrder());
    }

    @Override
    public void startDrawing(int drawMode) {
        if (this.drawing) {
            throw new IllegalStateException("Already drawing!");
        }
        this.drawMode = drawMode;
        this.drawing = true;
        this.vertexCount = 0;
        this.hasColor = false;
        this.hasTexture = false;
        this.hasLightmap = false;
        this.hasNormal = false;
        this.lockedColor = false;
        this.buffer.clear();
    }

    @Override
    public void draw() {
        this.checkIsDrawing();
        this.drawing = false;
        if (this.vertexCount == 0) {
            return;
        }
        int vertexSize = this.getVertexSize();
        int offset = 0;
        this.buffer.flip();
        GL13.glEnableClientState((int)32884);
        this.buffer.position(0);
        GL13.glVertexPointer((int)3, (int)5126, (int)vertexSize, (ByteBuffer)this.buffer);
        offset += 12;
        if (this.hasColor) {
            GL13.glEnableClientState((int)32886);
            this.buffer.position(offset);
            GL13.glColorPointer((int)4, (int)5121, (int)vertexSize, (ByteBuffer)this.buffer);
            offset += 4;
        } else {
            GL13.glDisableClientState((int)32886);
        }
        if (this.hasTexture) {
            GL13.glEnableClientState((int)32888);
            this.buffer.position(offset);
            GL13.glTexCoordPointer((int)2, (int)5126, (int)vertexSize, (ByteBuffer)this.buffer);
            offset += 8;
        } else {
            GL13.glDisableClientState((int)32888);
        }
        if (this.hasLightmap) {
            GL13.glClientActiveTexture((int)33985);
            GL13.glEnableClientState((int)32888);
            this.buffer.position(offset);
            GL13.glTexCoordPointer((int)2, (int)5122, (int)vertexSize, (ByteBuffer)this.buffer);
            GL13.glClientActiveTexture((int)33984);
            offset += 4;
        } else {
            GL13.glClientActiveTexture((int)33985);
            GL13.glDisableClientState((int)32888);
            GL13.glClientActiveTexture((int)33984);
        }
        if (this.hasNormal) {
            GL13.glEnableClientState((int)32885);
            this.buffer.position(offset);
            GL13.glNormalPointer((int)5120, (int)vertexSize, (ByteBuffer)this.buffer);
            offset += 3;
        } else {
            GL13.glDisableClientState((int)32885);
        }
        GL13.glDrawArrays((int)this.drawMode, (int)0, (int)this.vertexCount);
    }

    public int getVertexSize() {
        int vertexSize = 12;
        if (this.hasColor) {
            vertexSize += 4;
        }
        if (this.hasTexture) {
            vertexSize += 8;
        }
        if (this.hasLightmap) {
            vertexSize += 4;
        }
        if (this.hasNormal) {
            vertexSize += 3;
        }
        return vertexSize;
    }

    @Override
    public void addVertex(double x, double y, double z) {
        this.checkIsDrawing();
        if (this.buffer.capacity() < this.buffer.position() + 64) {
            int newSize = this.buffer.capacity() * 2;
            System.out.println("Expanding Tessellator Buffer (" + this.buffer.capacity() + " -> " + newSize + ")");
            ByteBuffer newBuffer = ByteBuffer.allocateDirect(newSize).order(ByteOrder.nativeOrder());
            this.buffer.flip();
            newBuffer.put(this.buffer);
            this.buffer = newBuffer;
        }
        this.buffer.putFloat((float)(this.offsetX + x));
        this.buffer.putFloat((float)(this.offsetY + y));
        this.buffer.putFloat((float)(this.offsetZ + z));
        if (this.hasColor) {
            this.buffer.putInt(this.color);
        }
        if (this.hasTexture) {
            this.buffer.putFloat((float)this.textureU);
            this.buffer.putFloat((float)this.textureV);
        }
        if (this.hasLightmap) {
            this.buffer.putInt(this.lightmapCoord);
        }
        if (this.hasNormal) {
            this.buffer.put(this.normalX);
            this.buffer.put(this.normalY);
            this.buffer.put(this.normalZ);
        }
        ++this.vertexCount;
    }

    @Override
    public void setTextureUV(double u, double v) {
        this.checkIsDrawing();
        if (!this.hasTexture) {
            if (this.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.hasTexture = true;
        }
        this.textureU = u;
        this.textureV = v;
    }

    @Override
    public void setLightmapCoord(int lightmapCoord) {
        this.checkIsDrawing();
        if (!this.hasLightmap) {
            if (this.vertexCount > 0) {
                throw new IllegalStateException("Lightmap is disabled!");
            }
            this.hasLightmap = true;
        }
        this.lightmapCoord = lightmapCoord;
    }

    @Override
    public void setColorRGBA(int r, int g, int b, int a) {
        this.checkIsDrawing();
        if (this.lockedColor) {
            return;
        }
        if (!this.hasColor) {
            if (this.vertexCount > 0) {
                throw new IllegalStateException("Color is disabled!");
            }
            this.hasColor = true;
        }
        r = MathHelper.clamp(r, 0, 255);
        g = MathHelper.clamp(g, 0, 255);
        b = MathHelper.clamp(b, 0, 255);
        a = MathHelper.clamp(a, 0, 255);
        this.color = a << 24 | b << 16 | g << 8 | r;
    }

    @Override
    public void setNormal(float x, float y, float z) {
        this.checkIsDrawing();
        if (!this.hasNormal) {
            if (this.vertexCount > 0) {
                throw new IllegalStateException("Texture is disabled!");
            }
            this.hasNormal = true;
        }
        this.normalX = (byte)(x * 127.0f);
        this.normalY = (byte)(y * 127.0f);
        this.normalZ = (byte)(z * 127.0f);
    }

    @Override
    public void lockColor() {
        this.checkIsDrawing();
        this.lockedColor = true;
    }

    @Override
    public void setTranslation(double x, double y, double z) {
        this.offsetX = x;
        this.offsetY = y;
        this.offsetZ = z;
    }

    @Override
    public void offsetTranslation(float x, float y, float z) {
        this.offsetX += (double)x;
        this.offsetY += (double)y;
        this.offsetZ += (double)z;
    }

    @Override
    public void checkIsDrawing() {
        if (!this.drawing) {
            throw new IllegalStateException("Not drawing!");
        }
    }
}

