/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.render.window;

import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import net.minecraft.client.Minecraft;
import net.minecraft.client.MinecraftApplet;
import net.minecraft.client.render.PanelCrashReport;
import net.minecraft.client.render.window.GameWindow;
import net.minecraft.core.UnexpectedThrowable;
import org.lwjgl.LWJGLException;
import org.lwjgl.opengl.Display;
import org.lwjgl.opengl.PixelFormat;

public class GameWindowApplet
implements GameWindow {
    private MinecraftApplet applet;
    private Minecraft mc;
    private Canvas canvas;

    public GameWindowApplet(MinecraftApplet minecraftApplet) {
        this.applet = minecraftApplet;
    }

    @Override
    public void init(Minecraft minecraft) throws LWJGLException {
        this.mc = minecraft;
        this.canvas = this.applet.getCanvas();
        Graphics g = this.canvas.getGraphics();
        g.setColor(Color.black);
        g.fillRect(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        g.dispose();
        Display.setParent(this.canvas);
        try {
            Display.create(new PixelFormat().withDepthBits(24));
        }
        catch (Exception e) {
            e.printStackTrace();
            try {
                Thread.sleep(1000L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Display.create();
        }
    }

    @Override
    public boolean isBorderlessFullscreenSupported() {
        return false;
    }

    @Override
    public void setResizable(boolean resizable) {
    }

    @Override
    public void toggleFullscreen() {
        this.mc.gameSettings.fullscreen.toggle();
        this.updateWindowState();
    }

    @Override
    public void updateWindowState() {
        boolean fullscreen = (Boolean)this.mc.gameSettings.fullscreen.value;
        try {
            if (fullscreen) {
                Display.setDisplayMode(Display.getDesktopDisplayMode());
                Display.setFullscreen(true);
            } else {
                Display.setFullscreen(false);
            }
            this.mc.resize();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void displayCrashReport(UnexpectedThrowable unexpectedThrowable, int cause) {
        this.applet.removeAll();
        this.applet.setLayout(new BorderLayout());
        this.applet.add((Component)new PanelCrashReport(this.mc, unexpectedThrowable, cause), "Center");
        this.applet.validate();
    }
}

