/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.sound;

import java.io.File;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.client.sound.SoundEntry;

public class SoundRepository {
    private final Random random = new Random();
    private final Map<String, List<SoundEntry>> urls = new HashMap<String, List<SoundEntry>>();
    private final List<SoundEntry> allEntries = new ArrayList<SoundEntry>();
    public int entryCount = 0;
    public boolean trimDigits = true;

    public SoundEntry addSound(String fileName, File file) {
        String id = fileName;
        try {
            id = id.substring(0, id.indexOf("."));
            if (this.trimDigits) {
                while (Character.isDigit(id.charAt(id.length() - 1))) {
                    id = id.substring(0, id.length() - 1);
                }
            }
            if (!this.urls.containsKey(id = id.replaceAll("/", "."))) {
                this.urls.put(id, new ArrayList());
            }
            SoundEntry soundEntry = new SoundEntry(id, fileName, file.toURI().toURL());
            this.urls.get(id).add(soundEntry);
            this.allEntries.add(soundEntry);
            ++this.entryCount;
            return soundEntry;
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Adding Sound: " + id + " (" + file.getAbsolutePath() + ")", e);
        }
    }

    public SoundEntry getEntry(String name) {
        List<SoundEntry> values = this.urls.get(name);
        if (values == null) {
            return null;
        }
        return values.get(this.random.nextInt(values.size()));
    }

    public SoundEntry getAnyEntry() {
        if (this.allEntries.isEmpty()) {
            return null;
        }
        return this.allEntries.get(this.random.nextInt(this.allEntries.size()));
    }

    public List<SoundEntry> getAllEntries() {
        return this.allEntries;
    }
}

