/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.client.util.helper;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiContainer;
import net.minecraft.client.gui.GuiRenderItem;
import net.minecraft.core.InventoryAction;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.player.inventory.slot.Slot;
import org.lwjgl.input.Keyboard;
import org.lwjgl.opengl.GL11;

public class GuiItemDragHandler
extends Gui {
    public final Minecraft mc;
    public final GuiContainer container;
    public final GuiRenderItem guiRenderItem;
    private int renderOffsetX;
    private int renderOffsetY;
    private Set<Integer> cancelRelease = new HashSet<Integer>();
    private int cancelButtonRelease = -1;
    private int draggingButton = -1;
    private ItemStack draggingItemStack;
    private final List<Slot> draggedSlots = new ArrayList<Slot>();
    private ItemStack renderItemStack;
    private int renderItemStackCount;
    private Slot lastClickSlot = null;
    private long lastClickTime = 0L;
    private boolean lastClickHoldingItem = false;
    private boolean doubleClick = false;

    public GuiItemDragHandler(Minecraft minecraft, GuiContainer container, GuiRenderItem renderItem) {
        this.mc = minecraft;
        this.container = container;
        this.guiRenderItem = renderItem;
    }

    public void drawScreen(int mouseX, int mouseY, float partialTicks) {
        this.renderOffsetX = 0;
        this.renderOffsetY = 0;
        if (this.isDragging()) {
            Slot slot = this.getSlotAt(mouseX, mouseY);
            this.onDragOverSlot(slot);
            if (this.draggedSlots.size() > 1) {
                boolean isCreativeDragging;
                this.renderItemStack = this.draggingItemStack.copy();
                this.renderItemStack.stackSize = 1;
                boolean bl = isCreativeDragging = this.draggingButton == 2 && !this.mc.thePlayer.getGamemode().consumeBlocks();
                this.renderItemStackCount = isCreativeDragging ? this.draggingItemStack.getMaxStackSize() : (this.draggingButton == 1 ? 1 : this.draggingItemStack.stackSize / this.draggedSlots.size());
                for (int i = 0; i < this.draggedSlots.size(); ++i) {
                    this.drawSlotOverlayWhileDragging(this.draggedSlots.get(i));
                }
                this.renderItemStack.stackSize = isCreativeDragging ? 1 : this.draggingItemStack.stackSize - this.draggedSlots.size() * this.renderItemStackCount;
            }
        }
    }

    private void onDragOverSlot(Slot slot) {
        boolean isCreativeDragging;
        if (slot == null) {
            return;
        }
        boolean bl = isCreativeDragging = this.draggingButton == 2 && !this.mc.thePlayer.getGamemode().consumeBlocks();
        if (this.draggedSlots.size() >= this.draggingItemStack.stackSize && !isCreativeDragging) {
            return;
        }
        if (slot.mayPlace(this.draggingItemStack) && slot.enableDragAndPickup() && (slot.getItem() == null || slot.getItem().canStackWith(this.draggingItemStack)) && !this.draggedSlots.contains(slot)) {
            this.draggedSlots.add(slot);
        }
    }

    private void drawSlotOverlayWhileDragging(Slot slot) {
        if (slot == null) {
            throw new NullPointerException("Slot is null");
        }
        if (this.draggingItemStack == null) {
            throw new NullPointerException("Stack is null!");
        }
        ItemStack stack = slot.getItem();
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.drawRectWidthHeight(this.renderOffsetX + slot.x, this.renderOffsetY + slot.y, 16, 16, -2130706433);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        this.renderItemStack.stackSize = this.renderItemStackCount;
        if (stack != null) {
            this.renderItemStack.stackSize = Math.min(this.renderItemStack.getMaxStackSize(), this.renderItemStack.stackSize + stack.stackSize);
        }
        this.guiRenderItem.render(this.renderItemStack, slot.x, slot.y);
    }

    public void mouseEvent(int x, int y, int button, boolean pressed) {
        boolean shift = Keyboard.isKeyDown(Keyboard.KEY_LSHIFT) || Keyboard.isKeyDown(Keyboard.KEY_RSHIFT);
        boolean control = Keyboard.isKeyDown(Keyboard.KEY_LCONTROL) || Keyboard.isKeyDown(Keyboard.KEY_RCONTROL);
        boolean alt = Keyboard.isKeyDown(Keyboard.KEY_LMENU) || Keyboard.isKeyDown(Keyboard.KEY_RMENU);
        boolean space = Keyboard.isKeyDown(Keyboard.KEY_SPACE);
        boolean mod = shift || control || alt || space;
        Slot slot = this.getSlotAt(x, y);
        if (pressed) {
            if (mod) {
                this.cancelRelease.add(button);
                this.container.clickInventory(x, y, button);
            } else {
                this.mousePressed(x, y, slot, button);
            }
        } else {
            if (this.cancelRelease.contains(button)) {
                this.cancelRelease.remove(button);
                return;
            }
            this.mouseReleased(x, y, slot, button);
        }
    }

    public void click(InventoryAction action, int[] args) {
        this.mc.playerController.handleInventoryMouseClick(this.container.inventorySlots.containerId, action, args, this.mc.thePlayer);
    }

    private void mousePressed(int x, int y, Slot slot, int button) {
        ItemStack stack = this.getGrabbedItem();
        if (button == 0) {
            long now = System.currentTimeMillis();
            long sinceLast = now - this.lastClickTime;
            this.doubleClick = this.lastClickSlot != null && this.lastClickSlot == slot && sinceLast < 250L && stack != null && !this.lastClickHoldingItem;
            this.lastClickSlot = slot;
            this.lastClickTime = now;
            boolean bl = this.lastClickHoldingItem = stack != null;
        }
        if (stack == null) {
            this.container.clickInventory(x, y, button);
            this.cancelButtonRelease = button;
        } else if (!this.isDragging()) {
            this.draggingButton = button;
            this.draggingItemStack = stack;
            this.draggedSlots.clear();
        }
    }

    private void mouseReleased(int x, int y, Slot slot, int button) {
        ItemStack stack = this.getGrabbedItem();
        if (stack == null) {
            return;
        }
        if (this.cancelButtonRelease != -1) {
            int cancelButton = this.cancelButtonRelease;
            this.cancelButtonRelease = -1;
            if (cancelButton == button) {
                return;
            }
        }
        boolean doClick = true;
        if (button == 0 && this.doubleClick && slot != null && slot.enableDragAndPickup()) {
            doClick = false;
            this.pickupSimilarItems(slot);
            this.doubleClick = false;
            this.stopDragging();
        }
        if (this.isDragging()) {
            if (button == this.draggingButton) {
                if (this.draggedSlots.size() > 0) {
                    this.spreadItemsAcrossDraggedSlots(x, y, button);
                    doClick = false;
                }
            } else {
                this.cancelButtonRelease = this.draggingButton;
                doClick = false;
            }
            this.stopDragging();
        }
        if (doClick) {
            this.container.clickInventory(x, y, button);
        }
    }

    private void stopDragging() {
        this.draggingButton = -1;
        this.draggingItemStack = null;
        this.draggedSlots.clear();
    }

    private void spreadItemsAcrossDraggedSlots(int x, int y, int mode) {
        InventoryAction action;
        if (this.draggedSlots.size() < 1) {
            return;
        }
        if (this.draggedSlots.size() == 1) {
            this.container.clickInventory(x, y, mode);
            return;
        }
        InventoryAction inventoryAction = action = mode == 1 ? InventoryAction.DRAG_ITEMS_ONE : InventoryAction.DRAG_ITEMS_ALL;
        if (mode == 2 && !this.mc.thePlayer.getGamemode().consumeBlocks()) {
            action = InventoryAction.CREATIVE_DRAG;
        }
        int[] slots = new int[this.draggedSlots.size()];
        for (int i = 0; i < slots.length; ++i) {
            slots[i] = this.draggedSlots.get((int)i).index;
        }
        this.mc.playerController.handleInventoryMouseClick(this.container.inventorySlots.containerId, action, slots, this.mc.thePlayer);
    }

    private void pickupSimilarItems(Slot slot) {
        if (!slot.enableDragAndPickup()) {
            return;
        }
        this.mc.playerController.handleInventoryMouseClick(this.container.inventorySlots.containerId, InventoryAction.PICKUP_SIMILAR, null, this.mc.thePlayer);
    }

    public boolean isDragging() {
        return this.draggingButton != -1;
    }

    private Slot getSlotAt(int x, int y) {
        return this.container.getSlotAtPosition(x, y);
    }

    private ItemStack getGrabbedItem() {
        return this.mc.thePlayer.inventory.getHeldItemStack();
    }

    public boolean isSlotDragged(Slot slot) {
        return this.draggedSlots.size() > 1 && this.draggedSlots.contains(slot);
    }

    public ItemStack getHeldItemRenderOverride() {
        if (this.isDragging() && this.draggedSlots.size() > 1) {
            return this.renderItemStack;
        }
        return null;
    }
}

