/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.achievement.stat;

import com.b100.utils.StringUtils;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import net.minecraft.core.achievement.stat.Stat;
import net.minecraft.core.achievement.stat.StatsCounter;
import net.minecraft.core.player.Session;

public class StatsSyncher {
    private volatile boolean busy = false;
    private volatile Map<Stat, Integer> queuedLocalStatsChanges = null;
    private volatile Map<Stat, Integer> queuedSavedStatsChanges = null;
    private final StatsCounter statsCounter;
    private final File unsentStatsFile;
    private final File statsFile;
    private final File unsentStatsFileTemp;
    private final File statsFileTemp;
    private final File unsentStatsFileOld;
    private final File statsFileOld;
    private final Session session;
    private int saveTimer = 0;
    private int fetchChangesTimer = 0;

    public StatsSyncher(Session session, StatsCounter statsCounter, File statsDir) {
        this.unsentStatsFile = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.dat");
        this.statsFile = new File(statsDir, "stats_" + session.username.toLowerCase() + ".dat");
        this.unsentStatsFileOld = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.old");
        this.statsFileOld = new File(statsDir, "stats_" + session.username.toLowerCase() + ".old");
        this.unsentStatsFileTemp = new File(statsDir, "stats_" + session.username.toLowerCase() + "_unsent.tmp");
        this.statsFileTemp = new File(statsDir, "stats_" + session.username.toLowerCase() + ".tmp");
        if (!session.username.toLowerCase().equals(session.username)) {
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.dat", this.unsentStatsFile);
            this.renameFile(statsDir, "stats_" + session.username + ".dat", this.statsFile);
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.old", this.unsentStatsFileOld);
            this.renameFile(statsDir, "stats_" + session.username + ".old", this.statsFileOld);
            this.renameFile(statsDir, "stats_" + session.username + "_unsent.tmp", this.unsentStatsFileTemp);
            this.renameFile(statsDir, "stats_" + session.username + ".tmp", this.statsFileTemp);
        }
        this.statsCounter = statsCounter;
        this.session = session;
        if (this.unsentStatsFile.exists()) {
            statsCounter.addToBoth(this.readStatsFromFile(this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld));
        }
        this.startRetrievalThread();
    }

    private void renameFile(File file, String s, File file1) {
        File file2 = new File(file, s);
        if (file2.exists() && !file2.isDirectory() && !file1.exists()) {
            file2.renameTo(file1);
        }
    }

    private Map<Stat, Integer> readStatsFromFile(File statsFile, File tempStatsFile, File oldStatsFile) {
        if (statsFile.exists()) {
            return this.readStatsFromFile(statsFile);
        }
        if (oldStatsFile.exists()) {
            return this.readStatsFromFile(oldStatsFile);
        }
        if (tempStatsFile.exists()) {
            return this.readStatsFromFile(tempStatsFile);
        }
        return null;
    }

    private Map<Stat, Integer> readStatsFromFile(File statsFile) {
        try {
            return StatsCounter.readStatsFromString(StringUtils.getFileContentAsString(statsFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private void saveStats(Map<Stat, Integer> map, File statsFile, File tempStatsFile, File oldStatsFile) throws IOException {
        try (PrintWriter writer = new PrintWriter(new FileWriter(tempStatsFile, false));){
            writer.print(StatsCounter.getStatFileContentString(this.session.username, "local", map));
        }
        if (oldStatsFile.exists()) {
            oldStatsFile.delete();
        }
        if (statsFile.exists()) {
            statsFile.renameTo(oldStatsFile);
        }
        tempStatsFile.renameTo(statsFile);
    }

    public void startRetrievalThread() {
        if (this.busy) {
            throw new IllegalStateException("Can't get stats from server while StatsSyncher is busy!");
        }
        this.saveTimer = 100;
        this.busy = true;
        new Thread(() -> {
            try {
                if (this.queuedLocalStatsChanges != null) {
                    this.saveStats(this.queuedLocalStatsChanges, this.statsFile, this.statsFileTemp, this.statsFileOld);
                } else if (this.statsFile.exists()) {
                    this.queuedLocalStatsChanges = this.readStatsFromFile(this.statsFile, this.statsFileTemp, this.statsFileOld);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.busy = false;
            }
        }).start();
    }

    public void startSavingThread(Map<Stat, Integer> mapToSave) {
        if (this.busy) {
            throw new IllegalStateException("Can't save stats while StatsSyncher is busy!");
        }
        this.saveTimer = 100;
        this.busy = true;
        new Thread(() -> {
            try {
                this.saveStats(mapToSave, this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                this.busy = false;
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveStatsToDisk(Map<Stat, Integer> map) {
        int i = 30;
        while (this.busy && --i > 0) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interrupt) {
                interrupt.printStackTrace();
            }
        }
        this.busy = true;
        try {
            this.saveStats(map, this.unsentStatsFile, this.unsentStatsFileTemp, this.unsentStatsFileOld);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.busy = false;
        }
    }

    public boolean pendingSave() {
        return this.saveTimer <= 0 && !this.busy && this.queuedSavedStatsChanges == null;
    }

    public void tick() {
        if (this.saveTimer > 0) {
            --this.saveTimer;
        }
        if (this.fetchChangesTimer > 0) {
            --this.fetchChangesTimer;
        }
        if (this.queuedSavedStatsChanges != null) {
            this.statsCounter.addToSaved(this.queuedSavedStatsChanges);
            this.queuedSavedStatsChanges = null;
        }
        if (this.queuedLocalStatsChanges != null) {
            this.statsCounter.addToLocal(this.queuedLocalStatsChanges);
            this.queuedLocalStatsChanges = null;
        }
    }
}

