/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.Blocks;
import net.minecraft.core.block.material.Material;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.item.IBonemealable;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.world.World;

public class MossBlock
extends Block
implements IBonemealable {
    public static Map<Integer, Integer> variantMap = new HashMap<Integer, Integer>();
    public static final Map<Block, Block> stoneToMossMap = new HashMap<Block, Block>();
    public static final Map<Block, Block> mossToStoneMap = new HashMap<Block, Block>();

    public MossBlock(String key, String namespaceId, int id, int parentId) {
        super(key, namespaceId, id, Material.moss);
        this.setTicking(true);
        variantMap.put(parentId, id);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        if (world.isClientSide) {
            return;
        }
        if (world.areBlocksLoaded(x, y, z, 16) && this.canMossSpread(world, x, y, z) && rand.nextInt(20) == 0) {
            this.spreadMossRandomly(world, x, y, z, rand, false);
        }
    }

    public boolean spreadMossRandomly(World world, int x, int y, int z, Random random, boolean ignoreLight) {
        Block mossStone;
        int mossX = x;
        int mossY = y;
        int mossZ = z;
        int side = random.nextInt(6);
        if (side == 0) {
            --mossZ;
        }
        if (side == 1) {
            ++mossX;
        }
        if (side == 2) {
            ++mossZ;
        }
        if (side == 3) {
            --mossX;
        }
        if (side == 4) {
            ++mossY;
        }
        if (side == 5) {
            --mossY;
        }
        if ((ignoreLight || !Block.isBuried(world, mossX, mossY, mossZ)) && (mossStone = MossBlock.getMossBlock(world.getBlockId(mossX, mossY, mossZ))) != null) {
            world.setBlockWithNotify(mossX, mossY, mossZ, mossStone.id);
            return true;
        }
        return false;
    }

    public boolean canMossSpread(World world, int x, int y, int z) {
        for (int i = 0; i < 6; ++i) {
            Side side = Side.getSideById(i);
            if (world.getBlockLightValue(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ()) <= 5 && world.isBlockLoaded(x + side.getOffsetX(), y + side.getOffsetY(), z + side.getOffsetZ())) continue;
            return false;
        }
        return true;
    }

    public static Block getMossBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return MossBlock.getMossBlock(Block.blocksList[blockId]);
    }

    public static Block getMossBlock(Block stoneBlock) {
        return stoneToMossMap.get(stoneBlock);
    }

    public static Block getStoneBlock(int blockId) {
        if (blockId == 0) {
            return null;
        }
        return MossBlock.getStoneBlock(Block.blocksList[blockId]);
    }

    public static Block getStoneBlock(Block mossBlock) {
        return mossToStoneMap.get(mossBlock);
    }

    public static void initMossMap() {
        stoneToMossMap.put(Blocks.STONE, Blocks.MOSS_STONE);
        stoneToMossMap.put(Blocks.GRANITE, Blocks.MOSS_GRANITE);
        stoneToMossMap.put(Blocks.LIMESTONE, Blocks.MOSS_LIMESTONE);
        stoneToMossMap.put(Blocks.BASALT, Blocks.MOSS_BASALT);
        stoneToMossMap.put(Blocks.COBBLE_STONE, Blocks.COBBLE_STONE_MOSSY);
        stoneToMossMap.put(Blocks.BRICK_STONE_POLISHED, Blocks.BRICK_STONE_POLISHED_MOSSY);
        stoneToMossMap.put(Blocks.LOG_OAK, Blocks.LOG_OAK_MOSSY);
        for (Map.Entry<Block, Block> entry : stoneToMossMap.entrySet()) {
            mossToStoneMap.put(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public boolean onBonemealUsed(ItemStack itemstack, Player entityplayer, World world, int blockX, int blockY, int blockZ, Side side, double xPlaced, double yPlaced) {
        if (!world.isClientSide) {
            if (entityplayer.getGamemode().consumeBlocks()) {
                --itemstack.stackSize;
            }
            for (int j1 = 0; j1 < 32; ++j1) {
                int k1 = blockX;
                int l1 = blockY;
                int i2 = blockZ;
                for (int j2 = 0; j2 < j1 / 16; ++j2) {
                    k1 += world.rand.nextInt(3) - 1;
                    l1 += (world.rand.nextInt(3) - 1) * world.rand.nextInt(3) / 2;
                    i2 += world.rand.nextInt(3) - 1;
                }
                if (Block.isBuried(world, k1, l1, i2) || world.getBlockLightValue(k1, l1 + 1, i2) > 5 || world.getBlockLightValue(k1, l1 - 1, i2) > 5 || world.getBlockLightValue(k1 + 1, l1, i2) > 5 || world.getBlockLightValue(k1 - 1, l1, i2) > 5 || world.getBlockLightValue(k1, l1, i2 - 1) > 5 || world.getBlockLightValue(k1, l1, i2 + 1) > 5) continue;
                if (world.getBlockId(k1, l1, i2) == Blocks.STONE.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.MOSS_STONE.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Blocks.LIMESTONE.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.MOSS_LIMESTONE.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Blocks.GRANITE.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.MOSS_GRANITE.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Blocks.BASALT.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.MOSS_BASALT.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Blocks.COBBLE_STONE.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.COBBLE_STONE_MOSSY.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) == Blocks.BRICK_STONE_POLISHED.id) {
                    world.setBlockWithNotify(k1, l1, i2, Blocks.BRICK_STONE_POLISHED_MOSSY.id);
                    continue;
                }
                if (world.getBlockId(k1, l1, i2) != Blocks.LOG_OAK.id) continue;
                world.setBlockWithNotify(k1, l1, i2, Blocks.LOG_OAK_MOSSY.id);
            }
        }
        return true;
    }
}

