/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.block;

import java.util.Random;
import net.minecraft.core.block.Block;
import net.minecraft.core.block.entity.BlockEntity;
import net.minecraft.core.block.material.MaterialColor;
import net.minecraft.core.entity.Entity;
import net.minecraft.core.entity.Mob;
import net.minecraft.core.entity.player.Player;
import net.minecraft.core.enums.EnumDropCause;
import net.minecraft.core.item.ItemStack;
import net.minecraft.core.item.block.SlabBlockItem;
import net.minecraft.core.util.helper.Direction;
import net.minecraft.core.util.helper.Side;
import net.minecraft.core.util.phys.AABB;
import net.minecraft.core.util.phys.Vec3;
import net.minecraft.core.world.World;
import net.minecraft.core.world.WorldSource;

public class SlabBlock
extends Block {
    public Block modelBlock;
    public int modelBlockMetadata;

    public SlabBlock(Block modelBlock, String namespaceId, int id) {
        this(modelBlock, namespaceId, id, 0);
        this.setBlockItem(() -> new SlabBlockItem(this));
    }

    public SlabBlock(Block modelBlock, String namespaceId, int id, int modelBlockMetadata) {
        super("slab." + modelBlock.key.substring(5), namespaceId, id, modelBlock.blockMaterial);
        this.modelBlock = modelBlock;
        this.modelBlockMetadata = modelBlockMetadata;
        this.withHardness(modelBlock.blockHardness);
        this.withBlastResistance(modelBlock.blastResistance / 3.0f);
        this.withLightEmission(lightEmission[modelBlock.id]);
        this.withLightBlock(1);
    }

    @Override
    public void setBlockBoundsBasedOnState(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 3;
        if (l == 0) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        } else if (l == 1) {
            this.setBlockBounds(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);
        } else if (l == 2) {
            this.setBlockBounds(0.0, 0.5, 0.0, 1.0, 1.0, 1.0);
        }
    }

    @Override
    public AABB getCollisionBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        int l = world.getBlockMetadata(x, y, z) & 3;
        if (l == 0) {
            return AABB.getTemporaryBB(x, y, z, (float)x + 1.0f, (float)y + 0.5f, (float)z + 1.0f);
        }
        if (l == 1) {
            return AABB.getTemporaryBB(x, y, z, x + 1, (float)y + 1.0f, (float)z + 1.0f);
        }
        return AABB.getTemporaryBB(x, (float)y + 0.5f, z, (float)x + 1.0f, (float)y + 1.0f, (float)z + 1.0f);
    }

    @Override
    public boolean isSolidRender() {
        return false;
    }

    @Override
    public boolean renderAsNormalBlockOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) == 1;
    }

    @Override
    public boolean canPlaceOnSurfaceOnCondition(World world, int x, int y, int z) {
        int meta = world.getBlockMetadata(x, y, z);
        return (meta & 3) != 0;
    }

    @Override
    public ItemStack[] getBreakResult(World world, EnumDropCause dropCause, int x, int y, int z, int meta, BlockEntity blockEntity) {
        ItemStack[] result = this.modelBlock.getBreakResult(world, dropCause, x, y, z, this.modelBlockMetadata, blockEntity);
        if (result != null) {
            for (ItemStack stack : result) {
                if (stack.itemID != this.modelBlock.id) continue;
                stack.setMetadata(meta & 0xF0);
                stack.itemID = this.id;
                stack.stackSize = (meta & 3) == 1 && dropCause != EnumDropCause.PICK_BLOCK ? 2 : 1;
            }
        }
        return result;
    }

    @Override
    public int tickDelay() {
        return this.modelBlock.tickDelay();
    }

    @Override
    public AABB getSelectedBoundingBoxFromPool(WorldSource world, int x, int y, int z) {
        return this.getCollisionBoundingBoxFromPool(world, x, y, z);
    }

    @Override
    public void handleEntityInside(World world, int x, int y, int z, Entity entity, Vec3 entityVelocity) {
        this.modelBlock.handleEntityInside(world, x, y, z, entity, entityVelocity);
    }

    @Override
    public boolean isCollidable() {
        return this.modelBlock.isCollidable();
    }

    @Override
    public boolean canCollideCheck(int meta, boolean shouldCollideWithFluids) {
        return this.modelBlock.canCollideCheck(meta, shouldCollideWithFluids);
    }

    @Override
    public boolean canPlaceBlockAt(World world, int x, int y, int z) {
        return world.getBlockId(x, y - 1, z) == this.id || world.getBlockId(x, y + 1, z) == this.id || super.canPlaceBlockAt(world, x, y, z);
    }

    @Override
    public void onEntityWalking(World world, int x, int y, int z, Entity entity) {
        this.modelBlock.onEntityWalking(world, x, y, z, entity);
    }

    @Override
    public void updateTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.updateTick(world, x, y, z, rand);
    }

    @Override
    public boolean onBlockRightClicked(World world, int x, int y, int z, Player player, Side side, double xPlaced, double yPlaced) {
        return this.modelBlock.onBlockRightClicked(world, x, y, z, player, side, xPlaced, yPlaced);
    }

    @Override
    public void onBlockDestroyedByExplosion(World world, int x, int y, int z) {
        this.modelBlock.onBlockDestroyedByExplosion(world, x, y, z);
    }

    @Override
    public void onBlockPlacedByMob(World world, int x, int y, int z, Side side, Mob mob, double sideHeight) {
        Direction dir = mob.getVerticalPlacementDirection(side, sideHeight);
        if (dir == Direction.DOWN) {
            world.setBlockMetadataWithNotify(x, y, z, 0);
        }
        if (dir == Direction.UP) {
            world.setBlockMetadataWithNotify(x, y, z, 2);
        }
    }

    @Override
    public void onBlockPlacedByWorld(World world, int x, int y, int z) {
        this.onNeighborBlockChange(world, x, y, z, 0);
        this.modelBlock.onBlockPlacedByWorld(world, x, y, z);
    }

    @Override
    public int getRenderLayer() {
        return this.modelBlock.getRenderLayer();
    }

    @Override
    public float getBlastResistance(Entity entity) {
        return this.modelBlock.getBlastResistance(entity);
    }

    @Override
    public float getBlockBrightness(WorldSource blockAccess, int x, int y, int z) {
        return this.modelBlock.getBlockBrightness(blockAccess, x, y, z);
    }

    @Override
    public void onBlockLeftClicked(World world, int x, int y, int z, Player player, Side side, double xHit, double yHit) {
        this.modelBlock.onBlockLeftClicked(world, x, y, z, player, side, xHit, yHit);
    }

    @Override
    public void animationTick(World world, int x, int y, int z, Random rand) {
        this.modelBlock.animationTick(world, x, y, z, rand);
    }

    @Override
    public MaterialColor getMaterialColor() {
        return this.modelBlock.getMaterialColor();
    }
}

